/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.RuntimeAssert;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class ImportFileOperation
extends BHive.Operation<ObjectId> {
    private Path file;

    @Override
    public ObjectId call() throws Exception {
        try (ActivityReporter.Activity activity = this.getActivityReporter().start("Importing file...", -1L);){
            RuntimeAssert.assertNotNull(this.file, "File to import not set");
            ObjectId objectId = this.getObjectManager().db(x -> x.addObject(this.file));
            return objectId;
        }
    }

    public ImportFileOperation setFile(Path file) {
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            throw new IllegalArgumentException("File does not exist: " + file);
        }
        this.file = file;
        return this;
    }
}

