/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.audit.AuditParameterExtractor;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.RuntimeAssert;

public class ImportObjectOperation
extends BHive.Operation<ObjectId> {
    @AuditParameterExtractor.NoAudit
    private byte[] data;

    @Override
    public ObjectId call() throws Exception {
        try (ActivityReporter.Activity activity = this.getActivityReporter().start("Importing data...", -1L);){
            RuntimeAssert.assertNotNull(this.data, "Data to import not set");
            ObjectId objectId = this.getObjectManager().db(x -> x.addObject(this.data));
            return objectId;
        }
    }

    public ImportObjectOperation setData(byte[] data) {
        this.data = (byte[])data.clone();
        return this;
    }
}

