/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.audit.AuditParameterExtractor;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.op.ImportTreeOperation;
import io.bdeploy.bhive.op.ManifestListOperation;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.RuntimeAssert;
import java.nio.file.Path;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;

public class ImportOperation
extends BHive.Operation<Manifest.Key> {
    private Path toImport;
    private Manifest.Key manifest;
    @AuditParameterExtractor.AuditWith(value=AuditParameterExtractor.AuditStrategy.COLLECTION_PEEK)
    private final Map<String, String> labels = new TreeMap<String, String>();

    @Override
    public Manifest.Key call() throws Exception {
        RuntimeAssert.assertNotNull(this.toImport, "Source path not set");
        RuntimeAssert.assertNotNull(this.manifest, "Manifest not set");
        try (ActivityReporter.Activity activity = this.getActivityReporter().start("Importing manifest...", -1L);){
            SortedSet<Manifest.Key> existing = this.execute(new ManifestListOperation());
            if (existing.contains(this.manifest)) {
                throw new IllegalArgumentException("Manifest " + this.manifest + " already present");
            }
            Manifest.Builder builder = new Manifest.Builder(this.manifest);
            builder.setRoot(this.execute(new ImportTreeOperation().setSourcePath(this.toImport)));
            this.labels.forEach(builder::addLabel);
            this.getManifestDatabase().addManifest(builder.build(this));
        }
        return this.manifest;
    }

    public ImportOperation setSourcePath(Path toImport) {
        this.toImport = toImport;
        return this;
    }

    public ImportOperation setManifest(Manifest.Key manifest) {
        this.manifest = manifest;
        return this;
    }

    public ImportOperation addLabel(String key, String value) {
        this.labels.put(key, value);
        return this;
    }
}

