/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.audit.AuditParameterExtractor;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.RuntimeAssert;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class InsertManifestOperation
extends BHive.Operation<Long> {
    @AuditParameterExtractor.AuditWith(value=AuditParameterExtractor.AuditStrategy.COLLECTION_PEEK)
    private final SortedMap<Manifest.Key, Manifest> manifests = new TreeMap<Manifest.Key, Manifest>();

    @Override
    public Long call() throws Exception {
        RuntimeAssert.assertFalse(this.manifests.isEmpty(), "Nothing to insert");
        try (ActivityReporter.Activity activity = this.getActivityReporter().start("Inserting manifests...", -1L);){
            for (Map.Entry<Manifest.Key, Manifest> entry : this.manifests.entrySet()) {
                if (this.getManifestDatabase().hasManifest(entry.getValue().getKey())) continue;
                this.getManifestDatabase().addManifest(entry.getValue());
                activity.workAndCancelIfRequested(1L);
            }
        }
        return this.manifests.size();
    }

    public InsertManifestOperation addManifest(Manifest manifest) {
        this.manifests.put(manifest.getKey(), manifest);
        return this;
    }
}

