/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.objects.view.ElementView;
import io.bdeploy.bhive.objects.view.TreeView;
import io.bdeploy.bhive.objects.view.scanner.TreeVisitor;
import io.bdeploy.bhive.op.ManifestDeleteOperation;
import io.bdeploy.bhive.op.ScanOperation;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.RuntimeAssert;
import java.util.ArrayList;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class ManifestConsistencyCheckOperation
extends BHive.Operation<Set<ElementView>> {
    private final SortedSet<Manifest.Key> manifests = new TreeSet<Manifest.Key>();
    private boolean dryRun = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ElementView> call() throws Exception {
        RuntimeAssert.assertFalse(this.manifests.isEmpty(), "Nothing to check");
        TreeSet<ElementView> dmg = new TreeSet<ElementView>();
        ActivityReporter.Activity check = this.getActivityReporter().start("Checking manifest tree consistency...", this.manifests.size());
        try {
            for (Manifest.Key key : this.manifests) {
                ArrayList broken = new ArrayList();
                TreeView state = this.execute(new ScanOperation().setManifest(key));
                state.visit(new TreeVisitor.Builder().onMissing(broken::add).build());
                if (!broken.isEmpty() && !this.dryRun) {
                    this.execute(new ManifestDeleteOperation().setToDelete(key));
                }
                dmg.addAll(broken);
                check.workAndCancelIfRequested(1L);
            }
        }
        finally {
            check.done();
        }
        return dmg;
    }

    public ManifestConsistencyCheckOperation addRoot(Manifest.Key key) {
        this.manifests.add(key);
        return this;
    }

    public ManifestConsistencyCheckOperation setDryRun(boolean dry) {
        this.dryRun = dry;
        return this;
    }
}

