/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.ReadOnlyOperation;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.RuntimeAssert;
import java.util.Optional;

@ReadOnlyOperation
public class ManifestMaxIdOperation
extends BHive.Operation<Optional<Long>> {
    private String key;

    @Override
    public Optional<Long> call() throws Exception {
        RuntimeAssert.assertNotNull(this.key, "No Manifest to inspect");
        ActivityReporter.Activity activity = this.getActivityReporter().start("Evaluating latest manifest version...", -1L);
        try {
            Optional<Long> optional = this.getManifestDatabase().getAllForName(this.key).stream().map(Manifest.Key::getTag).map(Long::parseLong).max(Long::compare);
            if (activity != null) {
                activity.close();
            }
            return optional;
        }
        catch (Throwable throwable) {
            try {
                if (activity != null) {
                    try {
                        activity.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
    }

    public ManifestMaxIdOperation setManifestName(String name) {
        this.key = name;
        return this;
    }
}

