/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.ReadOnlyOperation;
import io.bdeploy.bhive.op.ManifestMaxIdOperation;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.RuntimeAssert;
import java.util.Optional;

@ReadOnlyOperation
public class ManifestNextIdOperation
extends BHive.Operation<Long> {
    private String key;

    @Override
    public Long call() throws Exception {
        RuntimeAssert.assertNotNull(this.key, "No Manifest to inspect");
        try (ActivityReporter.Activity activity = this.getActivityReporter().start("Evaluating next manifest version...", -1L);){
            Optional<Long> max = this.execute(new ManifestMaxIdOperation().setManifestName(this.key));
            Long l = max.orElse(0L) + 1L;
            return l;
        }
    }

    public ManifestNextIdOperation setManifestName(String name) {
        this.key = name;
        return this;
    }
}

