/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.audit.AuditParameterExtractor;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.objects.MarkerDatabase;
import io.bdeploy.bhive.objects.view.ElementView;
import io.bdeploy.bhive.objects.view.ManifestRefView;
import io.bdeploy.bhive.objects.view.TreeView;
import io.bdeploy.bhive.objects.view.scanner.TreeVisitor;
import io.bdeploy.bhive.op.ManifestExistsOperation;
import io.bdeploy.bhive.op.ManifestListOperation;
import io.bdeploy.bhive.op.ScanOperation;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.PathHelper;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class ObjectConsistencyCheckOperation
extends BHive.Operation<Set<ElementView>> {
    @AuditParameterExtractor.AuditWith(value=AuditParameterExtractor.AuditStrategy.COLLECTION_PEEK)
    private final SortedSet<Manifest.Key> roots = new TreeSet<Manifest.Key>();
    private boolean dryRun = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ElementView> call() throws Exception {
        if (this.roots.isEmpty()) {
            SortedSet<Manifest.Key> localManifests = this.execute(new ManifestListOperation());
            this.roots.addAll(localManifests);
        }
        ActivityReporter.Activity scanning = this.getActivityReporter().start("Scanning manifest trees...", this.roots.size());
        Path markerPath = Files.createTempDirectory("markers-", new FileAttribute[0]);
        MarkerDatabase markerDb = new MarkerDatabase(markerPath, this.getActivityReporter());
        TreeSet<ElementView> broken = new TreeSet<ElementView>();
        try {
            for (Manifest.Key key : this.roots) {
                ArrayList<ElementView> existingElements = new ArrayList<ElementView>();
                if (!this.execute(new ManifestExistsOperation().setManifest(key)).booleanValue()) continue;
                TreeView state = this.execute(new ScanOperation().setManifest(key));
                if (state.getElementId() == null) {
                    broken.add(state.getChildren().values().iterator().next());
                    continue;
                }
                state.visit(new TreeVisitor.Builder().onBlob(existingElements::add).onTree(existingElements::add).onManifestRef(existingElements::add).build());
                broken.addAll(this.checkElements(markerDb, existingElements));
                scanning.workAndCancelIfRequested(1L);
            }
        }
        finally {
            scanning.done();
            PathHelper.deleteRecursive(markerPath);
        }
        return broken;
    }

    private Set<ElementView> checkElements(MarkerDatabase markerDb, List<ElementView> existingElements) {
        TreeSet<ElementView> broken = new TreeSet<ElementView>();
        for (ElementView obj : existingElements) {
            if (markerDb.hasObject(obj.getElementId())) continue;
            markerDb.addMarker(obj.getElementId());
            if (!this.getObjectManager().checkObject(obj.getElementId(), !this.dryRun)) {
                broken.add(obj);
            }
            if (!(obj instanceof ManifestRefView)) continue;
            ObjectId ref = ((ManifestRefView)obj).getReferenceId();
            if (this.getObjectManager().checkObject(ref, !this.dryRun)) continue;
            broken.add(obj);
        }
        return broken;
    }

    public ObjectConsistencyCheckOperation addRoot(Manifest.Key key) {
        this.roots.add(key);
        return this;
    }

    public ObjectConsistencyCheckOperation setDryRun(boolean dry) {
        this.dryRun = dry;
        return this;
    }
}

