/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.ReadOnlyOperation;
import io.bdeploy.bhive.audit.AuditParameterExtractor;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.common.ActivityReporter;
import java.util.SortedSet;
import java.util.TreeSet;

@ReadOnlyOperation
public class ObjectExistsOperation
extends BHive.Operation<SortedSet<ObjectId>> {
    @AuditParameterExtractor.AuditWith(value=AuditParameterExtractor.AuditStrategy.COLLECTION_SIZE)
    private final SortedSet<ObjectId> objects = new TreeSet<ObjectId>();

    @Override
    public SortedSet<ObjectId> call() throws Exception {
        TreeSet<ObjectId> existing = new TreeSet<ObjectId>();
        try (ActivityReporter.Activity activity = this.getActivityReporter().start("Checking objects...", -1L);){
            for (ObjectId o : this.objects) {
                if (!this.getObjectManager().db(x -> x.hasObject(o)).booleanValue()) continue;
                existing.add(o);
            }
        }
        return existing;
    }

    public ObjectExistsOperation addObject(ObjectId obj) {
        this.objects.add(obj);
        return this;
    }
}

