/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.ReadOnlyOperation;
import io.bdeploy.bhive.audit.AuditParameterExtractor;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.objects.ObjectDatabase;
import io.bdeploy.bhive.objects.view.ElementView;
import io.bdeploy.bhive.objects.view.ManifestRefView;
import io.bdeploy.bhive.objects.view.TreeView;
import io.bdeploy.bhive.objects.view.scanner.TreeVisitor;
import io.bdeploy.bhive.op.ManifestLoadOperation;
import io.bdeploy.bhive.op.ScanOperation;
import io.bdeploy.common.ActivityReporter;
import java.util.ArrayList;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ReadOnlyOperation
public class ObjectListOperation
extends BHive.Operation<SortedSet<ObjectId>> {
    private static final Logger log = LoggerFactory.getLogger(ObjectListOperation.class);
    @AuditParameterExtractor.AuditWith(value=AuditParameterExtractor.AuditStrategy.COLLECTION_PEEK)
    private final SortedSet<Manifest.Key> manifests = new TreeSet<Manifest.Key>();
    @AuditParameterExtractor.AuditWith(value=AuditParameterExtractor.AuditStrategy.COLLECTION_SIZE)
    private final SortedSet<ObjectId> trees = new TreeSet<ObjectId>();
    @AuditParameterExtractor.AuditWith(value=AuditParameterExtractor.AuditStrategy.COLLECTION_SIZE)
    private final SortedSet<ObjectId> treeExcludes = new TreeSet<ObjectId>();

    @Override
    public SortedSet<ObjectId> call() throws Exception {
        try (ActivityReporter.Activity activity = this.getActivityReporter().start("Listing objects...", -1L);){
            for (Manifest.Key m3 : this.manifests) {
                this.trees.add(this.execute(new ManifestLoadOperation().setManifest(m3)).getRoot());
            }
            if (this.trees.isEmpty()) {
                SortedSet sortedSet = this.getObjectManager().db(ObjectDatabase::getAllObjects);
                return sortedSet;
            }
            TreeSet result = new TreeSet();
            for (ObjectId tree : this.trees) {
                ArrayList scanned = new ArrayList();
                TreeView state = this.execute(new ScanOperation().setTree(tree));
                if (state.getElementId() == null) {
                    log.warn("Skipping damaged tree: {}", (Object)tree);
                    continue;
                }
                state.visit(new TreeVisitor.Builder().onBlob(scanned::add).onTree(t -> {
                    if (this.treeExcludes.contains(t.getElementId())) {
                        return false;
                    }
                    scanned.add(t);
                    return true;
                }).onManifestRef(scanned::add).build());
                scanned.stream().map(ElementView::getElementId).forEach(result::add);
                scanned.stream().filter(ManifestRefView.class::isInstance).map(x -> ((ManifestRefView)x).getReferenceId()).forEach(result::add);
            }
            TreeSet treeSet = result;
            return treeSet;
        }
    }

    public ObjectListOperation addManifest(Manifest.Key manifest) {
        this.manifests.add(manifest);
        return this;
    }

    public ObjectListOperation addTree(ObjectId tree) {
        this.trees.add(tree);
        return this;
    }

    public ObjectListOperation excludeTree(ObjectId tree) {
        this.treeExcludes.add(tree);
        return this;
    }
}

