/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.ReadOnlyOperation;
import io.bdeploy.bhive.audit.AuditParameterExtractor;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.RuntimeAssert;
import java.util.SortedSet;
import java.util.TreeSet;

@ReadOnlyOperation
public class ObjectSizeOperation
extends BHive.Operation<Long> {
    @AuditParameterExtractor.AuditWith(value=AuditParameterExtractor.AuditStrategy.COLLECTION_SIZE)
    private final SortedSet<ObjectId> objects = new TreeSet<ObjectId>();

    @Override
    public Long call() throws Exception {
        RuntimeAssert.assertFalse(this.objects.isEmpty(), "No objects to measure");
        try (ActivityReporter.Activity activity = this.getActivityReporter().start("Listing object sizes...", -1L);){
            Long l = this.objects.stream().mapToLong(id -> this.getObjectManager().db(x -> x.getObjectSize((ObjectId)id))).sum();
            return l;
        }
    }

    public ObjectSizeOperation addObject(ObjectId object) {
        this.objects.add(object);
        return this;
    }
}

