/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.objects.MarkerDatabase;
import io.bdeploy.bhive.objects.ObjectDatabase;
import io.bdeploy.bhive.op.ManifestListOperation;
import io.bdeploy.bhive.op.ObjectListOperation;
import io.bdeploy.common.ActivityReporter;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class PruneOperation
extends BHive.Operation<SortedMap<ObjectId, Long>> {
    @Override
    public SortedMap<ObjectId, Long> call() throws Exception {
        TreeMap<ObjectId, Long> result = new TreeMap<ObjectId, Long>();
        try (ActivityReporter.Activity activity = this.getActivityReporter().start("Pruning hive...", -1L);){
            SortedSet<Object> referenced;
            SortedSet<Manifest.Key> manifests = this.execute(new ManifestListOperation());
            if (!manifests.isEmpty()) {
                ObjectListOperation listOp = new ObjectListOperation();
                manifests.forEach(listOp::addManifest);
                referenced = this.execute(listOp);
            } else {
                referenced = new TreeSet();
            }
            MarkerDatabase.lockRoot(this.getMarkerRoot());
            SortedSet orig = this.getObjectManager().db(ObjectDatabase::getAllObjects);
            TreeSet all = new TreeSet(orig);
            all.removeAll(referenced);
            try (DirectoryStream<Path> markerDbs = Files.newDirectoryStream(this.getMarkerRoot());){
                for (Path markerDb : markerDbs) {
                    if (!Files.isDirectory(markerDb, new LinkOption[0])) continue;
                    MarkerDatabase mdb = new MarkerDatabase(markerDb, this.getActivityReporter());
                    all.removeAll(mdb.getAllObjects());
                }
            }
            MarkerDatabase.unlockRoot(this.getMarkerRoot());
            for (ObjectId unreferenced : all) {
                result.put(unreferenced, this.getObjectManager().db(x -> {
                    long sz = x.getObjectSize(unreferenced);
                    x.removeObject(unreferenced);
                    return sz;
                }));
            }
            TreeMap<ObjectId, Long> treeMap = result;
            return treeMap;
        }
    }
}

