/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.ReadOnlyOperation;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.objects.view.TreeView;
import io.bdeploy.bhive.op.ManifestLoadOperation;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.RuntimeAssert;

@ReadOnlyOperation
public class ScanOperation
extends BHive.Operation<TreeView> {
    private ObjectId treeId;
    private int maxDepth = Integer.MAX_VALUE;
    private Manifest.Key manifest;
    private boolean followReferences = true;

    @Override
    public TreeView call() throws Exception {
        try (ActivityReporter.Activity activity = this.getActivityReporter().start("Scanning manifest...", -1L);){
            if (this.manifest != null) {
                Manifest mf = this.execute(new ManifestLoadOperation().setManifest(this.manifest));
                RuntimeAssert.assertNotNull(mf, "Given manifest not found");
                this.treeId = mf.getRoot();
            }
            RuntimeAssert.assertNotNull(this.treeId, "No tree to scan");
            TreeView treeView = this.getObjectManager().scan(this.treeId, this.maxDepth, this.followReferences);
            return treeView;
        }
    }

    public ScanOperation setManifest(Manifest.Key manifest) {
        this.manifest = manifest;
        return this;
    }

    public ScanOperation setTree(ObjectId treeId) {
        this.treeId = treeId;
        return this;
    }

    public ScanOperation setMaxDepth(int max) {
        this.maxDepth = max;
        return this;
    }

    public ScanOperation setFollowReferences(boolean follow) {
        this.followReferences = follow;
        return this;
    }
}

