/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.ReadOnlyOperation;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.model.Tree;
import io.bdeploy.bhive.util.StorageHelper;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.RuntimeAssert;
import java.io.InputStream;

@ReadOnlyOperation
public class TreeLoadOperation
extends BHive.Operation<Tree> {
    private ObjectId treeId;

    @Override
    public Tree call() throws Exception {
        RuntimeAssert.assertNotNull(this.treeId, "Tree to load not set");
        try (InputStream is = this.getObjectManager().db(x -> x.getStream(this.treeId));){
            ActivityReporter.Activity activity = this.getActivityReporter().start("Retrieving tree...", -1L);
            try {
                Tree tree = StorageHelper.fromStream(is, Tree.class);
                if (activity != null) {
                    activity.close();
                }
                return tree;
            }
            catch (Throwable throwable) {
                if (activity != null) {
                    try {
                        activity.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    public TreeLoadOperation setTree(ObjectId tree) {
        this.treeId = tree;
        return this;
    }
}

