/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op.remote;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.op.CopyOperation;
import io.bdeploy.bhive.op.ObjectExistsOperation;
import io.bdeploy.bhive.op.remote.RemoteOperation;
import io.bdeploy.bhive.op.remote.TransferStatistics;
import io.bdeploy.bhive.remote.RemoteBHive;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.RuntimeAssert;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.ws.rs.core.UriBuilder;

public class FetchOperation
extends RemoteOperation<TransferStatistics, FetchOperation> {
    private final SortedSet<Manifest.Key> manifests = new TreeSet<Manifest.Key>();
    private String hiveName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransferStatistics call() throws Exception {
        TransferStatistics stats = new TransferStatistics();
        RuntimeAssert.assertNotNull(this.getRemote(), "Remote not set");
        TreeSet<Manifest.Key> toFetch = new TreeSet<Manifest.Key>();
        TreeSet<ObjectId> toFetchRootTrees = new TreeSet<ObjectId>();
        try (ActivityReporter.Activity activity = this.getActivityReporter().start("Fetching manifests...", -1L);
             RemoteBHive rh = RemoteBHive.forService(this.getRemote(), this.hiveName, this.getActivityReporter());){
            SortedMap<Manifest.Key, ObjectId> remoteManifests = rh.getManifestInventory((String[])this.manifests.stream().map(Manifest.Key::toString).toArray(String[]::new));
            if (this.manifests.isEmpty()) {
                this.manifests.addAll(remoteManifests.keySet());
            }
            for (Manifest.Key key : this.manifests) {
                if (!remoteManifests.containsKey(key)) {
                    throw new IllegalArgumentException("Manifest not found: " + key);
                }
                if (this.getManifestDatabase().hasManifest(key)) continue;
                toFetch.add(key);
                toFetchRootTrees.add((ObjectId)remoteManifests.get(key));
            }
            if (toFetch.isEmpty()) {
                TransferStatistics transferStatistics = stats;
                return transferStatistics;
            }
            stats.sumManifests = toFetch.size();
            TreeSet requiredTrees = new TreeSet();
            toFetchRootTrees.forEach(t -> requiredTrees.addAll(rh.getRequiredTrees((ObjectId)t)));
            stats.sumTrees = requiredTrees.size();
            ObjectExistsOperation findExistingTrees = new ObjectExistsOperation();
            requiredTrees.forEach(findExistingTrees::addObject);
            SortedSet<ObjectId> treesWeAlreadyHave = this.execute(findExistingTrees);
            TreeSet<ObjectId> missingTrees = new TreeSet<ObjectId>(requiredTrees);
            missingTrees.removeAll(treesWeAlreadyHave);
            stats.sumMissingTrees = missingTrees.size();
            SortedSet<ObjectId> requiredObjects = rh.getRequiredObjects(missingTrees, treesWeAlreadyHave);
            ObjectExistsOperation findExistingObjects = new ObjectExistsOperation();
            requiredObjects.forEach(findExistingObjects::addObject);
            SortedSet<ObjectId> existingObjects = this.execute(findExistingObjects);
            TreeSet<ObjectId> missingObjects = new TreeSet<ObjectId>(requiredObjects);
            missingObjects.removeAll(existingObjects);
            stats.sumMissingObjects = missingObjects.size();
            Path z = rh.fetch(missingObjects, toFetch);
            stats.transferSize = Files.size(z);
            try (BHive zHive = new BHive(UriBuilder.fromUri("jar:" + z.toUri()).build(new Object[0]), this.getActivityReporter());){
                zHive.execute(new CopyOperation().setDestinationHive(this).setPartialAllowed(false));
            }
            finally {
                Files.deleteIfExists(z);
            }
        }
        return stats;
    }

    public FetchOperation addManifest(Manifest.Key key) {
        this.manifests.add(key);
        return this;
    }

    public FetchOperation setHiveName(String name) {
        this.hiveName = name;
        return this;
    }

    public SortedSet<Manifest.Key> getManifests() {
        return this.manifests;
    }
}

