/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op.remote;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.ReadOnlyOperation;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.objects.view.ElementView;
import io.bdeploy.bhive.objects.view.ManifestRefView;
import io.bdeploy.bhive.objects.view.TreeView;
import io.bdeploy.bhive.objects.view.scanner.TreeVisitor;
import io.bdeploy.bhive.op.CopyOperation;
import io.bdeploy.bhive.op.ManifestListOperation;
import io.bdeploy.bhive.op.ManifestRefScanOperation;
import io.bdeploy.bhive.op.ScanOperation;
import io.bdeploy.bhive.op.remote.RemoteOperation;
import io.bdeploy.bhive.op.remote.TransferStatistics;
import io.bdeploy.bhive.remote.RemoteBHive;
import io.bdeploy.common.ActivityReporter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriBuilder;

@ReadOnlyOperation
public class PushOperation
extends RemoteOperation<TransferStatistics, PushOperation> {
    private final SortedSet<Manifest.Key> manifests = new TreeSet<Manifest.Key>();
    private String hiveName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransferStatistics call() throws Exception {
        TransferStatistics stats = new TransferStatistics();
        TreeSet<Manifest.Key> toPush = new TreeSet<Manifest.Key>();
        try (ActivityReporter.Activity activity = this.getActivityReporter().start("Pushing manifests...", -1L);){
            if (this.manifests.isEmpty()) {
                this.manifests.addAll((Collection<Manifest.Key>)this.execute(new ManifestListOperation()));
            }
            try (RemoteBHive rh = RemoteBHive.forService(this.getRemote(), this.hiveName, this.getActivityReporter());){
                SortedMap<Manifest.Key, ObjectId> remoteManifests = rh.getManifestInventory((String[])this.manifests.parallelStream().map(Manifest.Key::toString).toArray(String[]::new));
                for (Manifest.Key key : this.manifests) {
                    if (remoteManifests.containsKey(key)) continue;
                    toPush.add(key);
                }
                this.manifests.forEach(m3 -> toPush.addAll(this.execute(new ManifestRefScanOperation().setManifest((Manifest.Key)m3)).values()));
                if (toPush.isEmpty()) {
                    TransferStatistics transferStatistics = stats;
                    return transferStatistics;
                }
                stats.sumManifests = toPush.size();
                List<TreeView> snapshots = toPush.stream().map(m3 -> this.execute(new ScanOperation().setManifest((Manifest.Key)m3).setFollowReferences(false))).collect(Collectors.toList());
                SortedSet<TreeView> allTreeSnapshots = this.scanAllTreeSnapshots(snapshots);
                SortedSet allTrees = allTreeSnapshots.parallelStream().map(ElementView::getElementId).collect(Collectors.toCollection(TreeSet::new));
                stats.sumTrees = allTrees.size();
                SortedSet<ObjectId> missingTrees = rh.getMissingObjects(allTrees);
                stats.sumMissingTrees = missingTrees.size();
                SortedSet missingTreeSnapshots = allTreeSnapshots.parallelStream().filter(t -> missingTrees.contains(t.getElementId())).collect(Collectors.toCollection(TreeSet::new));
                SortedSet<ObjectId> requiredObjects = this.scanAllObjectSnapshots(missingTreeSnapshots);
                SortedSet<ObjectId> missingObjects = rh.getMissingObjects(requiredObjects);
                stats.sumMissingObjects = missingObjects.size();
                Path tmpHive = Files.createTempFile("push-", ".zip", new FileAttribute[0]);
                Files.delete(tmpHive);
                try {
                    try (BHive emptyHive = new BHive(UriBuilder.fromUri("jar:" + tmpHive.toUri()).build(new Object[0]), this.getActivityReporter());){
                        CopyOperation op = new CopyOperation().setDestinationHive(emptyHive).setPartialAllowed(true);
                        missingObjects.forEach(op::addObject);
                        toPush.forEach(op::addManifest);
                        this.execute(op);
                    }
                    stats.transferSize = Files.size(tmpHive);
                    rh.push(tmpHive);
                }
                finally {
                    Files.deleteIfExists(tmpHive);
                }
            }
        }
        return stats;
    }

    private SortedSet<TreeView> scanAllTreeSnapshots(List<TreeView> toPush) {
        TreeSet<TreeView> allTrees = new TreeSet<TreeView>();
        TreeVisitor visitor = new TreeVisitor.Builder().onTree(t -> {
            if (t instanceof ManifestRefView) {
                return false;
            }
            allTrees.add((TreeView)t);
            return true;
        }).build();
        for (TreeView snapshot : toPush) {
            snapshot.visit(visitor);
        }
        return allTrees;
    }

    private SortedSet<ObjectId> scanAllObjectSnapshots(SortedSet<TreeView> missingTreeSnapshots) {
        return missingTreeSnapshots.parallelStream().map(t -> {
            TreeSet<ObjectId> objectsOfTree = new TreeSet<ObjectId>();
            t.visit(new TreeVisitor.Builder().onTree(t::equals).onBlob(b -> objectsOfTree.add(b.getElementId())).onManifestRef(m3 -> objectsOfTree.add(m3.getReferenceId())).build());
            objectsOfTree.add(t.getElementId());
            return objectsOfTree;
        }).flatMap(Collection::stream).collect(Collectors.toCollection(TreeSet::new));
    }

    public PushOperation addManifest(Manifest.Key key) {
        this.manifests.add(key);
        return this;
    }

    public PushOperation setHiveName(String name) {
        this.hiveName = name;
        return this;
    }
}

