/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.remote;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.objects.view.TreeView;
import io.bdeploy.bhive.objects.view.scanner.TreeVisitor;
import io.bdeploy.bhive.op.CopyOperation;
import io.bdeploy.bhive.op.ManifestDeleteOperation;
import io.bdeploy.bhive.op.ManifestListOperation;
import io.bdeploy.bhive.op.ManifestLoadOperation;
import io.bdeploy.bhive.op.ObjectExistsOperation;
import io.bdeploy.bhive.op.ObjectListOperation;
import io.bdeploy.bhive.op.PruneOperation;
import io.bdeploy.bhive.op.ScanOperation;
import io.bdeploy.bhive.remote.RemoteBHive;
import io.bdeploy.common.ActivityReporter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.ws.rs.core.UriBuilder;

public class LocalBHiveAdapter
implements RemoteBHive {
    private final BHive hive;
    private final ActivityReporter reporter;

    public LocalBHiveAdapter(BHive hive, ActivityReporter reporter) {
        this.hive = hive;
        this.reporter = reporter;
    }

    @Override
    public SortedSet<ObjectId> getMissingObjects(SortedSet<ObjectId> all) {
        try (ActivityReporter.Activity activity = this.reporter.start("Scanning for missing objects...");){
            ObjectExistsOperation findExisting = new ObjectExistsOperation();
            all.forEach(findExisting::addObject);
            SortedSet<ObjectId> known = this.hive.execute(findExisting);
            TreeSet<ObjectId> result = new TreeSet<ObjectId>(all);
            result.removeAll(known);
            TreeSet<ObjectId> treeSet = result;
            return treeSet;
        }
    }

    @Override
    public SortedSet<ObjectId> getRequiredObjects(SortedSet<ObjectId> trees, SortedSet<ObjectId> excludeTrees) {
        ObjectListOperation objectListOperation = new ObjectListOperation();
        trees.forEach(objectListOperation::addTree);
        excludeTrees.forEach(objectListOperation::excludeTree);
        return this.hive.execute(objectListOperation);
    }

    @Override
    public SortedSet<ObjectId> getRequiredTrees(ObjectId tree) {
        TreeView snapshot = this.hive.execute(new ScanOperation().setTree(tree));
        TreeSet<ObjectId> treeIds = new TreeSet<ObjectId>();
        snapshot.visit(new TreeVisitor.Builder().onTree(x -> treeIds.add(x.getElementId())).build());
        return treeIds;
    }

    @Override
    public SortedMap<Manifest.Key, ObjectId> getManifestInventory(String ... names) {
        TreeSet mfs = new TreeSet();
        if (names.length == 0) {
            mfs.addAll(this.hive.execute(new ManifestListOperation()));
        } else {
            for (String name : names) {
                mfs.addAll(this.hive.execute(new ManifestListOperation().setManifestName(name)));
            }
        }
        TreeMap<Manifest.Key, ObjectId> result = new TreeMap<Manifest.Key, ObjectId>();
        for (Manifest.Key key : mfs) {
            result.put(key, this.hive.execute(new ManifestLoadOperation().setManifest(key)).getRoot());
        }
        return result;
    }

    @Override
    public void removeManifest(Manifest.Key key) {
        this.hive.execute(new ManifestDeleteOperation().setToDelete(key));
    }

    @Override
    public void prune() {
        this.hive.execute(new PruneOperation());
    }

    @Override
    public void push(Path zipedHive) {
        if (!Files.exists(zipedHive, new LinkOption[0])) {
            throw new IllegalArgumentException("File does not exist: " + zipedHive);
        }
        try (BHive packed = new BHive(UriBuilder.fromUri("jar:" + zipedHive.toUri()).build(new Object[0]), this.reporter);){
            packed.execute(new CopyOperation().setDestinationHive(this.hive).setPartialAllowed(false));
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot push to local repository", e);
        }
    }

    @Override
    public Path fetch(SortedSet<ObjectId> requiredObjects, SortedSet<Manifest.Key> manifestsToFetch) {
        try {
            Path tmpHive = Files.createTempFile("fetch-", ".zip", new FileAttribute[0]);
            Files.delete(tmpHive);
            try (BHive emptyHive = new BHive(UriBuilder.fromUri("jar:" + tmpHive.toUri()).build(new Object[0]), this.reporter);){
                CopyOperation op = new CopyOperation().setDestinationHive(emptyHive).setPartialAllowed(true);
                requiredObjects.forEach(op::addObject);
                manifestsToFetch.forEach(op::addManifest);
                this.hive.execute(op);
            }
            return tmpHive;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot fetch from local repository", e);
        }
    }

    @Override
    public void close() {
        this.hive.close();
    }
}

