/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.remote.jersey;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.bdeploy.bhive.model.Manifest;
import java.io.IOException;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.binding.AbstractBinder;

public class BHiveJacksonModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;

    public BHiveJacksonModule() {
        this.addKeySerializer(Manifest.Key.class, new MKS());
        this.addKeyDeserializer(Manifest.Key.class, new MKD());
    }

    public Binder binder() {
        return new AbstractBinder(){

            @Override
            protected void configure() {
                this.bind(BHiveJacksonModule.this).to(Module.class);
            }
        };
    }

    private static class MKD
    extends KeyDeserializer {
        private MKD() {
        }

        @Override
        public Object deserializeKey(String key, DeserializationContext ctxt) throws IOException {
            return Manifest.Key.parse(key);
        }
    }

    private static class MKS
    extends JsonSerializer<Manifest.Key> {
        private MKS() {
        }

        @Override
        public void serialize(Manifest.Key value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeFieldName(value.toString());
        }
    }
}

