/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.remote.jersey;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.remote.jersey.BHiveLocator;
import io.bdeploy.bhive.remote.jersey.BHiveRegistry;
import io.bdeploy.bhive.remote.jersey.BHiveResource;
import io.bdeploy.bhive.remote.jersey.BHiveResourceImpl;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.security.ScopedPermission;
import io.bdeploy.jersey.fs.FileSystemSpaceService;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BHiveLocatorImpl
implements BHiveLocator {
    private static final Logger log = LoggerFactory.getLogger(BHiveLocatorImpl.class);
    @Inject
    private BHiveRegistry registry;
    @Inject
    private ActivityReporter reporter;
    @Inject
    private FileSystemSpaceService fsss;
    @Context
    private ResourceContext rc;
    @Context
    private ContainerRequestContext context;

    @Override
    public BHiveResource getNamedHive(String name) {
        BHive hive;
        block4: {
            hive = this.registry.get(name);
            if (hive == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            try {
                Path path = Paths.get(hive.getUri());
                if (!this.fsss.hasFreeSpace(path)) {
                    throw new WebApplicationException("Not enough free space in " + path, Response.Status.SERVICE_UNAVAILABLE);
                }
            }
            catch (IllegalArgumentException | SecurityException | FileSystemNotFoundException e) {
                log.warn("Cannot check free space on {}", (Object)hive.getUri());
                if (!log.isDebugEnabled()) break block4;
                log.debug("Error:", e);
            }
        }
        return this.rc.initResource(new BHiveResourceImpl(hive, this.reporter));
    }

    @Override
    public ScopedPermission.Permission getRequiredPermission(String name) {
        BHive hive = this.registry.get(name);
        if (hive == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return this.registry.getRequiredPermission(this.registry.get(name));
    }
}

