/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.remote.jersey;

import io.bdeploy.bhive.BHive;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.security.ScopedPermission;
import io.bdeploy.common.util.RuntimeAssert;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.binding.AbstractBinder;

public class BHiveRegistry
implements AutoCloseable {
    private final Set<Path> locations = new TreeSet<Path>();
    private final Map<String, BHive> hives = new TreeMap<String, BHive>();
    private final ActivityReporter reporter;
    private final Function<BHive, ScopedPermission.Permission> permissionClassifier;

    public BHiveRegistry(ActivityReporter reporter, Function<BHive, ScopedPermission.Permission> permissionClassifier) {
        this.reporter = reporter;
        this.permissionClassifier = permissionClassifier;
    }

    public ScopedPermission.Permission getRequiredPermission(BHive hive) {
        if (this.permissionClassifier == null) {
            return ScopedPermission.Permission.READ;
        }
        return this.permissionClassifier.apply(hive);
    }

    public void register(String name, BHive hive) {
        this.hives.put(name, hive);
    }

    public void unregister(String name) {
        BHive hive = this.hives.remove(name);
        RuntimeAssert.assertNotNull(hive);
        hive.close();
    }

    public BHive get(String name) {
        return this.hives.get(name);
    }

    public Map<String, BHive> getAll() {
        return this.hives;
    }

    public Set<Path> getLocations() {
        return this.locations;
    }

    public void scanLocation(Path location) {
        this.locations.add(location);
        HiveFinder finder = new HiveFinder();
        try {
            Files.walkFileTree(location, finder);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot scan location: " + location, e);
        }
        finder.hives.forEach(dir -> this.register(dir.getFileName().toString(), new BHive(dir.toUri(), this.reporter)));
    }

    public Binder binder() {
        return new AbstractBinder(){

            @Override
            protected void configure() {
                this.bind(BHiveRegistry.this).to(BHiveRegistry.class);
            }
        };
    }

    @Override
    public void close() {
        this.hives.values().forEach(BHive::close);
        this.hives.clear();
    }

    private static final class HiveFinder
    extends SimpleFileVisitor<Path> {
        List<Path> hives = new ArrayList<Path>();

        private HiveFinder() {
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path o = dir.resolve("objects");
            Path m3 = dir.resolve("manifests");
            if (Files.isDirectory(o, new LinkOption[0]) && Files.isDirectory(m3, new LinkOption[0])) {
                this.hives.add(dir);
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

