/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.remote.jersey;

import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.common.security.RequiredPermission;
import io.bdeploy.common.security.ScopedPermission;
import io.bdeploy.jersey.JerseyAuthenticationProvider;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/hive")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface BHiveResource {
    @POST
    @JerseyAuthenticationProvider.WeakTokenAllowed
    @Path(value="/manifests")
    public SortedMap<Manifest.Key, ObjectId> getManifestInventory(String ... var1);

    @POST
    @Path(value="/manifest_remove")
    @RequiredPermission(permission=ScopedPermission.Permission.WRITE)
    public void removeManifest(Manifest.Key var1);

    @POST
    @Path(value="/prune")
    public void prune();

    @POST
    @JerseyAuthenticationProvider.WeakTokenAllowed
    @Path(value="/obj_missing")
    public SortedSet<ObjectId> getMissingObjects(SortedSet<ObjectId> var1);

    @POST
    @JerseyAuthenticationProvider.WeakTokenAllowed
    @Path(value="/tree_objects")
    public SortedSet<ObjectId> getRequiredObjects(ObjectListSpec var1);

    @POST
    @JerseyAuthenticationProvider.WeakTokenAllowed
    @Path(value="/tree_trees")
    public SortedSet<ObjectId> getRequiredTrees(ObjectId var1);

    @PUT
    @Path(value="/push")
    @Consumes(value={"application/octet-stream"})
    @RequiredPermission(permission=ScopedPermission.Permission.WRITE)
    public void push(java.nio.file.Path var1);

    @POST
    @JerseyAuthenticationProvider.WeakTokenAllowed
    @Path(value="/fetch")
    @Produces(value={"application/octet-stream"})
    public java.nio.file.Path fetch(FetchSpec var1);

    public static class ObjectListSpec {
        SortedSet<ObjectId> trees;
        SortedSet<ObjectId> excludeTrees;
    }

    public static class FetchSpec {
        SortedSet<ObjectId> requiredObjects;
        SortedSet<Manifest.Key> manifestsToFetch;
    }
}

