/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.remote.jersey;

import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.remote.RemoteBHive;
import io.bdeploy.bhive.remote.jersey.BHiveJacksonModule;
import io.bdeploy.bhive.remote.jersey.BHiveLocator;
import io.bdeploy.bhive.remote.jersey.BHiveResource;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.security.RemoteService;
import io.bdeploy.jersey.JerseyClientFactory;
import java.nio.file.Path;
import java.util.SortedMap;
import java.util.SortedSet;

public class JerseyRemoteBHive
implements RemoteBHive {
    public static final BHiveJacksonModule HIVE_JACKSON_MODULE = new BHiveJacksonModule();
    public static final String DEFAULT_NAME = "default";
    private final BHiveResource client;

    public JerseyRemoteBHive(RemoteService service, String name, ActivityReporter reporter) {
        JerseyClientFactory jcf = JerseyClientFactory.get(service);
        jcf.register(HIVE_JACKSON_MODULE);
        jcf.setReporter(reporter);
        this.client = jcf.getProxyClient(BHiveLocator.class, new Object[0]).getNamedHive(name == null ? DEFAULT_NAME : name);
    }

    @Override
    public SortedSet<ObjectId> getMissingObjects(SortedSet<ObjectId> all) {
        return this.client.getMissingObjects(all);
    }

    @Override
    public SortedMap<Manifest.Key, ObjectId> getManifestInventory(String ... names) {
        return this.client.getManifestInventory(names);
    }

    @Override
    public void removeManifest(Manifest.Key key) {
        this.client.removeManifest(key);
    }

    @Override
    public void prune() {
        this.client.prune();
    }

    @Override
    public SortedSet<ObjectId> getRequiredObjects(SortedSet<ObjectId> trees, SortedSet<ObjectId> excludeTrees) {
        BHiveResource.ObjectListSpec spec = new BHiveResource.ObjectListSpec();
        spec.trees = trees;
        spec.excludeTrees = excludeTrees;
        return this.client.getRequiredObjects(spec);
    }

    @Override
    public SortedSet<ObjectId> getRequiredTrees(ObjectId tree) {
        return this.client.getRequiredTrees(tree);
    }

    @Override
    public void push(Path zipedHive) {
        this.client.push(zipedHive);
    }

    @Override
    public Path fetch(SortedSet<ObjectId> availableObjects, SortedSet<Manifest.Key> manifestsToFetch) {
        BHiveResource.FetchSpec spec = new BHiveResource.FetchSpec();
        spec.requiredObjects = availableObjects;
        spec.manifestsToFetch = manifestsToFetch;
        return this.client.fetch(spec);
    }

    @Override
    public void close() {
    }
}

