/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.bdeploy.bhive.model.Tree;
import io.bdeploy.bhive.remote.jersey.BHiveJacksonModule;
import io.bdeploy.bhive.util.SimpleTreeMapper;
import io.bdeploy.common.util.JacksonHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class StorageHelper {
    private static final String JSON_READ_ERROR = "Cannot read JSON value";
    private static final String JSON_WRITE_ERROR = "Cannot write JSON value";
    private static final Map<Class<?>, CustomMapper> customMappers = new HashMap();

    public static byte[] toRawBytes(Object o) {
        CustomMapper m3 = customMappers.get(o.getClass());
        if (m3 != null) {
            return m3.write(o);
        }
        try {
            return StorageHelper.getMapper().writeValueAsBytes(o);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(JSON_WRITE_ERROR, e);
        }
    }

    public static byte[] toRawYamlBytes(Object o) {
        try {
            return StorageHelper.getMapper(JacksonHelper.MapperType.YAML).writeValueAsBytes(o);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(JSON_WRITE_ERROR, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T fromRawBytes(byte[] bytes, Class<T> clazz) {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
            T t = StorageHelper.fromStream(bis, clazz);
            return t;
        }
        catch (IOException e) {
            throw new IllegalStateException(JSON_READ_ERROR, e);
        }
    }

    public static <T> T fromRawBytes(byte[] bytes, TypeReference<T> ref) {
        try {
            return StorageHelper.getMapper().readValue(bytes, ref);
        }
        catch (IOException e) {
            throw new IllegalStateException(JSON_READ_ERROR, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T fromPath(Path path, Class<T> clazz) {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            T t = StorageHelper.fromStream(is, clazz);
            return t;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read file " + path, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T fromStream(InputStream is, Class<T> clazz) {
        CustomMapper m3 = customMappers.get(clazz);
        if (m3 != null) {
            return (T)m3.read(is);
        }
        try (InputStreamReader r = new InputStreamReader(is, StandardCharsets.UTF_8);){
            T t = StorageHelper.getMapper().readValue(is, clazz);
            return t;
        }
        catch (IOException e) {
            throw new IllegalStateException(JSON_READ_ERROR, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T fromYamlStream(InputStream is, Class<T> clazz) {
        try (InputStreamReader r = new InputStreamReader(is, StandardCharsets.UTF_8);){
            T t = StorageHelper.getMapper(JacksonHelper.MapperType.YAML).readValue(is, clazz);
            return t;
        }
        catch (IOException e) {
            throw new IllegalStateException(JSON_READ_ERROR, e);
        }
    }

    private static ObjectMapper getMapper() {
        return StorageHelper.getMapper(JacksonHelper.MapperType.JSON);
    }

    private static ObjectMapper getMapper(JacksonHelper.MapperType type) {
        ObjectMapper dm = JacksonHelper.createObjectMapper(type);
        dm.registerModule(new BHiveJacksonModule());
        return dm;
    }

    static {
        customMappers.put(Tree.class, new SimpleTreeMapper());
    }

    public static interface CustomMapper {
        public byte[] write(Object var1);

        public Object read(InputStream var1);
    }
}

