/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.bdeploy.common.ActivitySnapshot;
import io.bdeploy.common.NoThrowAutoCloseable;
import io.bdeploy.common.security.RemoteService;
import io.bdeploy.common.util.JacksonHelper;
import io.bdeploy.common.util.NamedDaemonThreadFactory;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ActivityReporter {
    public Activity start(String var1);

    public Activity start(String var1, long var2);

    public Activity start(String var1, LongSupplier var2, LongSupplier var3);

    public NoThrowAutoCloseable proxyActivities(RemoteService var1);

    public static class Delegating
    implements ActivityReporter {
        private ActivityReporter delegate = new Null();

        public void setDelegate(ActivityReporter delegate) {
            this.delegate = delegate;
        }

        @Override
        public Activity start(String activity) {
            return this.delegate.start(activity);
        }

        @Override
        public Activity start(String activity, long maxWork) {
            return this.delegate.start(activity, maxWork);
        }

        @Override
        public Activity start(String activity, LongSupplier maxValue, LongSupplier currentValue) {
            return this.delegate.start(activity, maxValue, currentValue);
        }

        @Override
        public NoThrowAutoCloseable proxyActivities(RemoteService service) {
            return this.delegate.proxyActivities(service);
        }
    }

    public static class Null
    implements ActivityReporter {
        @Override
        public Activity start(String activity) {
            return new NullActivity();
        }

        @Override
        public Activity start(String activity, long maxWork) {
            return new NullActivity();
        }

        @Override
        public Activity start(String activity, LongSupplier maxValue, LongSupplier currentValue) {
            return new NullActivity();
        }

        @Override
        public NoThrowAutoCloseable proxyActivities(RemoteService service) {
            return () -> {};
        }

        private static final class NullActivity
        implements Activity {
            long startTime = System.currentTimeMillis();

            private NullActivity() {
            }

            @Override
            public void worked(long amount) {
            }

            @Override
            public void done() {
            }

            @Override
            public long duration() {
                return System.currentTimeMillis() - this.startTime;
            }

            @Override
            public boolean isCancelRequested() {
                return false;
            }
        }
    }

    public static final class Stream
    implements ActivityReporter {
        private static final Logger log = LoggerFactory.getLogger(Stream.class);
        private final PrintStream output;
        private ScheduledExecutorService updater;
        private ScheduledFuture<?> scheduled;
        private boolean verbose;
        private BiFunction<RemoteService, Consumer<byte[]>, NoThrowAutoCloseable> proxyConnector;
        private final Deque<AsyncActivity> activities = new ArrayDeque<AsyncActivity>();
        private final List<AsyncActivity> allActivities = new ArrayList<AsyncActivity>();
        private String lastReportedActivity = "init";
        private long lastReportedAmount;

        public Stream(PrintStream output) {
            this.output = output;
        }

        public void setVerboseSummary(boolean verbose) {
            this.verbose = verbose;
        }

        public synchronized void beginReporting() {
            if (this.updater == null) {
                this.updater = Executors.newSingleThreadScheduledExecutor(new NamedDaemonThreadFactory(() -> "Activity Reporter (Console)"));
            }
            this.scheduled = this.updater.scheduleAtFixedRate(() -> this.catchAll(this::report), 0L, 200L, TimeUnit.MILLISECONDS);
        }

        public synchronized void stopReporting() {
            if (this.scheduled != null) {
                this.scheduled.cancel(false);
            }
            this.scheduled = null;
            if (this.updater != null) {
                this.updater.shutdownNow();
                this.updater = null;
            }
            this.reportSummary();
            this.activities.clear();
            this.output.flush();
        }

        private void catchAll(Runnable x) {
            block2: {
                try {
                    x.run();
                }
                catch (Exception e) {
                    if (!log.isTraceEnabled()) break block2;
                    log.trace("Exception in stream reporter", e);
                }
            }
        }

        private synchronized void report() {
            boolean amountChanged;
            AsyncActivity current = this.activities.peek();
            if (current == null) {
                return;
            }
            Long currentAmount = current.getCurrentAmount();
            boolean activityChanged = this.lastReportedActivity != null && !current.activity.equals(this.lastReportedActivity);
            boolean bl = amountChanged = currentAmount != this.lastReportedAmount;
            if (!activityChanged && !amountChanged) {
                return;
            }
            this.output.print('\r');
            Long max = current.getMaxAmount();
            if (max < 0L) {
                this.output.print(String.format("[%1$08d] %2$-70s", current.duration(), current.activity));
            } else if (max == 0L) {
                this.output.print(String.format("[%1$08d] %2$-70s         /%3$8d", current.duration(), current.activity, currentAmount));
            } else {
                this.output.print(String.format("[%1$08d] %2$-70s %3$8d/%4$8d", current.duration(), current.activity, currentAmount, max));
            }
        }

        private synchronized void reportDone(AsyncActivity act) {
            this.output.print('\r');
            Long max = act.getMaxAmount();
            if (max < 0L) {
                this.output.print(String.format("[%1$08d] %2$-70s     DONE%n", act.duration(), act.activity));
            } else if (max == 0L) {
                this.output.print(String.format("[%1$08d] %2$-70s     DONE/%3$8d%n", act.duration(), act.activity, act.getCurrentAmount()));
            } else {
                this.output.print(String.format("[%1$08d] %2$-70s     DONE/%3$8d%n", act.duration(), act.activity, max));
            }
            this.output.flush();
            this.lastReportedActivity = null;
        }

        private void reportSummary() {
            if (this.allActivities.isEmpty()) {
                return;
            }
            if (this.verbose) {
                this.output.println();
                this.output.println(String.format("%1$-81s %2$s", "ACTIVITY", "DURATION"));
                this.output.println(Stream.repeat("=", 90));
                for (AsyncActivity act : this.allActivities) {
                    if (act.isNested) {
                        this.output.println(String.format("  %1$-79s %2$8d ms", act.activity, act.duration()));
                        continue;
                    }
                    this.output.println(String.format("%1$-81s %2$8d ms", act.activity, act.duration()));
                }
            }
        }

        private static String repeat(String s2, int n) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                builder.append(s2);
            }
            return builder.toString();
        }

        @Override
        public Activity start(String activity) {
            return this.start(activity, -1L);
        }

        @Override
        public synchronized Activity start(String activity, long maxWork) {
            return this.start(activity, () -> maxWork, null);
        }

        @Override
        public synchronized Activity start(String activity, LongSupplier maxValue, LongSupplier currentValue) {
            AsyncActivity act = new AsyncActivity(activity, maxValue, currentValue);
            this.activities.push(act);
            this.allActivities.add(act);
            return act;
        }

        private synchronized void done(AsyncActivity act) {
            this.activities.remove(act);
            this.reportDone(act);
        }

        public void setProxyConnector(BiFunction<RemoteService, Consumer<byte[]>, NoThrowAutoCloseable> proxyConnector) {
            this.proxyConnector = proxyConnector;
        }

        @Override
        public NoThrowAutoCloseable proxyActivities(RemoteService service) {
            return new StreamRemoteActivityProxy(service);
        }

        private class StreamRemoteActivityProxy
        implements NoThrowAutoCloseable {
            private NoThrowAutoCloseable source;

            public StreamRemoteActivityProxy(RemoteService svc) {
                if (svc != null && svc.getKeyStore() != null && Stream.this.proxyConnector != null) {
                    this.source = (NoThrowAutoCloseable)Stream.this.proxyConnector.apply(svc, this::onMessage);
                }
            }

            private void onMessage(byte[] event) {
                try {
                    ObjectMapper mapper = JacksonHelper.createObjectMapper(JacksonHelper.MapperType.JSON);
                    List<ActivitySnapshot> activityList = mapper.readValue(event, ActivitySnapshot.LIST_TYPE);
                    for (ActivitySnapshot act : activityList) {
                        Stream.this.output.println("SRV: " + act);
                    }
                }
                catch (Exception e) {
                    Stream.this.output.println("Cannot read server activities:");
                    e.printStackTrace(Stream.this.output);
                }
            }

            @Override
            public void close() {
                if (this.source != null) {
                    this.source.close();
                }
            }
        }

        private final class AsyncActivity
        implements Activity {
            private final String activity;
            private final LongAdder localCurrent = new LongAdder();
            private final LongSupplier currentAmount;
            private final LongSupplier maxAmount;
            private final long startTime;
            private long stopTime;
            private boolean isNested = false;

            public AsyncActivity(String activity, LongSupplier maxValue, LongSupplier currentValue) {
                this.activity = activity;
                this.maxAmount = maxValue;
                this.currentAmount = currentValue != null ? currentValue : this.localCurrent::sum;
                this.startTime = System.currentTimeMillis();
                this.isNested = !Stream.this.activities.isEmpty();
            }

            long getCurrentAmount() {
                if (this.stopTime != 0L && this.maxAmount.getAsLong() > 0L) {
                    return this.maxAmount.getAsLong();
                }
                return this.currentAmount.getAsLong();
            }

            long getMaxAmount() {
                return this.maxAmount.getAsLong();
            }

            @Override
            public boolean isCancelRequested() {
                return false;
            }

            @Override
            public void worked(long amount) {
                this.localCurrent.add(amount);
            }

            @Override
            public void done() {
                this.stopTime = System.currentTimeMillis();
                Stream.this.done(this);
            }

            @Override
            public long duration() {
                return (this.stopTime > 0L ? this.stopTime : System.currentTimeMillis()) - this.startTime;
            }
        }
    }

    public static class ActivityCancelledException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }

    public static interface Activity
    extends NoThrowAutoCloseable {
        public void worked(long var1);

        public void done();

        public long duration();

        public boolean isCancelRequested();

        default public void workAndCancelIfRequested(long amount) {
            this.worked(amount);
            if (this.isCancelRequested()) {
                this.done();
                throw new ActivityCancelledException();
            }
        }

        @Override
        default public void close() {
            this.done();
        }
    }
}

