/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;

public class Version
implements Comparable<Version> {
    private final int major;
    private final int minor;
    private final int micro;
    private final String qualifier;

    @JsonCreator
    public Version(@JsonProperty(value="major") int major, @JsonProperty(value="minor") int minor, @JsonProperty(value="micro") int micro, @JsonProperty(value="qualifier") String qualifier) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = qualifier;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    @Override
    public int compareTo(Version o) {
        return ComparisonChain.start().compare(this.major, o.major).compare(this.minor, o.minor).compare(this.micro, o.micro).compare(this.qualifier, o.qualifier, Ordering.natural().nullsLast()).result();
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.micro + (this.qualifier == null ? "" : this.qualifier);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.micro;
        result = 31 * result + this.minor;
        result = 31 * result + (this.qualifier == null ? 0 : this.qualifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        if (this.major != other.major) {
            return false;
        }
        if (this.micro != other.micro) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        return !(this.qualifier == null ? other.qualifier != null : !this.qualifier.equals(other.qualifier));
    }
}

