/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.cfg;

import com.google.common.base.Splitter;
import io.bdeploy.common.cfg.ConfigValidationException;
import io.bdeploy.common.cli.ToolBase;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public class Configuration {
    private final Map<String, Object> objects = new TreeMap<String, Object>();
    private final Map<Method, Object> conversions = new HashMap<Method, Object>();

    public void add(String ... arguments) {
        for (String arg : arguments) {
            if (arg.startsWith("--")) {
                String stripped = arg.substring(2);
                int equalsIndex = stripped.indexOf(61);
                if (equalsIndex != -1) {
                    this.addKeyValueArgument(stripped, equalsIndex);
                    continue;
                }
                this.objects.put(stripped, Boolean.TRUE);
                continue;
            }
            throw new IllegalStateException("Unsupported argument format: " + arg);
        }
    }

    private void addKeyValueArgument(String stripped, int equalsIndex) {
        String key = stripped.substring(0, equalsIndex);
        String value = stripped.substring(equalsIndex + 1);
        if (this.objects.containsKey(key)) {
            Object existing = this.objects.get(key);
            if (existing instanceof List) {
                ((List)existing).add(value);
            } else {
                ArrayList<Object> l = new ArrayList<Object>();
                l.add(existing);
                l.add(value);
                this.objects.put(key, l);
            }
        } else {
            this.objects.put(key, value);
        }
    }

    public Map<String, Object> getAllRawObjects() {
        return this.objects;
    }

    public void add(Properties properties) {
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.objects.put((String)k, v)));
    }

    public <T extends Annotation> T get(Class<? extends Annotation> target) {
        Annotation proxy = (Annotation)Proxy.newProxyInstance(target.getClassLoader(), new Class[]{target}, this::doMap);
        ArrayList<Exception> validationProblems = new ArrayList<Exception>();
        for (Method m3 : target.getDeclaredMethods()) {
            try {
                this.doMap(proxy, m3, null);
            }
            catch (Exception e) {
                validationProblems.add(e);
            }
        }
        if (!validationProblems.isEmpty()) {
            ConfigValidationException collector = new ConfigValidationException();
            for (Exception problem : validationProblems) {
                collector.addSuppressed(problem);
            }
            throw collector;
        }
        return (T)proxy;
    }

    private Object doMap(Object proxy, Method method, Object[] arguments) {
        EnvironmentFallback fallback;
        Object value;
        String key = method.getName();
        ConfigurationNameMapping mapping = method.getAnnotation(ConfigurationNameMapping.class);
        if (mapping != null) {
            key = mapping.value();
        }
        if ((value = this.objects.get(key)) == null && !ToolBase.isTestMode() && (fallback = method.getAnnotation(EnvironmentFallback.class)) != null) {
            value = System.getenv(fallback.value());
        }
        if (value == null && !method.getReturnType().isAnnotation()) {
            return method.getDefaultValue();
        }
        return this.doConvert(method, value);
    }

    private Object doConvert(Method method, Object object) {
        Object conversion = this.conversions.get(method);
        if (conversion != null) {
            return conversion;
        }
        Validator validator = method.getAnnotation(Validator.class);
        ValidationMessage vmsg = null;
        Class<ConfigValidator<?>> cv = null;
        if (validator != null && (vmsg = (cv = validator.value()).getAnnotation(ValidationMessage.class)) == null) {
            throw new IllegalStateException("No validation message set on validator class: " + cv);
        }
        UnaryOperator<Object> mapper = this.getMapper(method);
        Class<?> returnType = method.getReturnType();
        if (object != null && returnType.isAssignableFrom(object.getClass())) {
            this.validateOrThrow(object, method, cv, vmsg);
            if (returnType.isAssignableFrom(String.class)) {
                return mapper.apply(object);
            }
            return object;
        }
        if (returnType.isPrimitive() && !(object instanceof String)) {
            this.validateOrThrow(object, method, cv, vmsg);
            return object;
        }
        if (object instanceof List && returnType.isArray()) {
            List list = (List)object;
            Object targetArray = Array.newInstance(returnType.getComponentType(), list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(targetArray, i, this.convertType(returnType.getComponentType(), (String)list.get(i), mapper));
            }
            this.validateOrThrow(targetArray, method, cv, vmsg);
            this.conversions.put(method, targetArray);
            return targetArray;
        }
        if (!(object instanceof String) && !returnType.isAnnotation()) {
            throw new IllegalStateException("Illegal conversion from non-string object to different type: " + (object == null ? "null" : object.getClass()) + " to " + returnType);
        }
        conversion = this.convertType(returnType, (String)object, mapper);
        this.validateOrThrow(conversion, method, cv, vmsg);
        this.conversions.put(method, conversion);
        return conversion;
    }

    private UnaryOperator<Object> getMapper(Method method) {
        ConfigurationValueMapping mapping = method.getAnnotation(ConfigurationValueMapping.class);
        UnaryOperator mapper = s2 -> s2;
        if (mapping != null) {
            if (mapping.value() == ValueMapping.TO_LOWERCASE) {
                mapper = s2 -> s2.toString().toLowerCase();
            } else if (mapping.value() == ValueMapping.TO_UPPERCASE) {
                mapper = s2 -> s2.toString().toUpperCase();
            }
        }
        return mapper;
    }

    private void validateOrThrow(Object value, Method m3, Class<? extends ConfigValidator<?>> validator, ValidationMessage msg) {
        if (validator == null) {
            return;
        }
        try {
            ConfigValidator<?> v = validator.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (!v.validate(Configuration.cast(value))) {
                throw new IllegalArgumentException("--" + m3.getName() + ": " + String.format(msg.value(), value));
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Cannot validate value: " + value + " using validator: " + validator, e);
        }
    }

    public static <T> T cast(Object object) {
        return (T)object;
    }

    private Object convertType(Class<?> target, String source, Function<Object, Object> mapper) {
        if (target.equals(String.class)) {
            return mapper.apply(source);
        }
        if (target.equals(Long.TYPE)) {
            return Long.parseLong(source);
        }
        if (target.equals(Integer.TYPE)) {
            return Integer.parseInt(source);
        }
        if (target.equals(Short.TYPE)) {
            return Short.parseShort(source);
        }
        if (target.equals(Byte.TYPE)) {
            return Byte.parseByte(source);
        }
        if (target.equals(Boolean.TYPE)) {
            return Boolean.parseBoolean(source);
        }
        if (target.equals(Double.TYPE)) {
            return Double.parseDouble(source);
        }
        if (target.equals(Float.TYPE)) {
            return Float.valueOf(Float.parseFloat(source));
        }
        if (target.equals(Character.TYPE)) {
            if (source == null) {
                throw new IllegalArgumentException("Character conversion of null source not possible");
            }
            if (source.length() > 1) {
                throw new IllegalArgumentException("Character conversion with input length > 1: " + source);
            }
            return Character.valueOf(source.charAt(0));
        }
        if (target.isEnum()) {
            try {
                return target.getMethod("valueOf", String.class).invoke(null, mapper.apply(source));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new IllegalStateException("internal error resolving enumeration literal for " + target + " '" + source + "'", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e.getTargetException());
            }
        }
        if (target.isArray()) {
            List<String> split = Splitter.on(',').trimResults().omitEmptyStrings().splitToList(source);
            Object targetArray = Array.newInstance(target.getComponentType(), split.size());
            for (int i = 0; i < split.size(); ++i) {
                Array.set(targetArray, i, this.convertType(target.getComponentType(), split.get(i), mapper));
            }
            return targetArray;
        }
        if (target.isAnnotation()) {
            return this.get(target);
        }
        throw new IllegalStateException("Unsupported conversion to " + target);
    }

    public static void formatHelp(Class<? extends Annotation> cfg, PrintStream target, String indent) {
        for (Method m3 : cfg.getDeclaredMethods()) {
            Help h2 = m3.getAnnotation(Help.class);
            ConfigurationNameMapping mapping = m3.getAnnotation(ConfigurationNameMapping.class);
            String name = m3.getName();
            if (mapping != null) {
                name = mapping.value();
            }
            if (h2 != null) {
                target.println(indent + String.format("%1$20s%2$4s: %3$s", "--" + name, h2.arg() ? "=ARG" : "", h2.value()));
            } else {
                target.println(indent + name);
            }
            EnvironmentFallback env = m3.getAnnotation(EnvironmentFallback.class);
            if (env == null) continue;
            target.println(indent + String.format("%1$24s  (Environment variable '%2$s' is used as fallback if not given)", "", env.value()));
        }
    }

    @FunctionalInterface
    public static interface ConfigValidator<T> {
        public boolean validate(T var1);
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface EnvironmentFallback {
        public String value();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface ValidationMessage {
        public String value() default "Validation failed for $1%s";
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Validator {
        public Class<? extends ConfigValidator<?>> value();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface Help {
        public String value();

        public boolean arg() default true;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface ConfigurationValueMapping {
        public ValueMapping value();
    }

    public static enum ValueMapping {
        TO_UPPERCASE,
        TO_LOWERCASE;

    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface ConfigurationNameMapping {
        public String value();
    }
}

