/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.cfg;

import io.bdeploy.common.cfg.Configuration;
import java.util.regex.Pattern;

@Configuration.ValidationMessage(value="Not a valid host name: %s")
public class HostnameValidator
implements Configuration.ConfigValidator<String> {
    private static final Pattern HOSTNAME_PATTERN = Pattern.compile("(?:[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?\\.)*[a-z0-9][a-z0-9-]{0,61}[a-z0-9]");

    @Override
    public boolean validate(String value) {
        return HOSTNAME_PATTERN.matcher(value.toLowerCase()).matches();
    }
}

