/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.cfg;

import io.bdeploy.common.cfg.Configuration;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;

@Configuration.ValidationMessage(value="Path exists, but should not exist (or be an empty directory): %s")
public class NonExistingPathValidator
implements Configuration.ConfigValidator<String> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validate(String value) {
        Path p = Paths.get(value, new String[0]);
        if (Files.isDirectory(p, new LinkOption[0])) {
            try (Stream<Path> list = Files.list(p);){
                if (list.findAny().isPresent()) {
                    boolean bl = false;
                    return bl;
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot determine directory contents: " + p, e);
            }
        }
        if (Files.exists(p, new LinkOption[0])) return false;
        return true;
    }
}

