/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.cli;

import com.codahale.metrics.Timer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.cfg.ConfigValidationException;
import io.bdeploy.common.cfg.Configuration;
import io.bdeploy.common.cli.ToolDefaultVerbose;
import io.bdeploy.common.metrics.Metrics;
import io.bdeploy.common.util.VersionHelper;
import java.io.File;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

@SuppressFBWarnings
public abstract class ToolBase {
    private static boolean testMode = false;
    private static boolean testModeLLM = false;
    private static boolean failWithException = false;
    private final Map<String, Class<? extends CliTool>> tools = new TreeMap<String, Class<? extends CliTool>>();

    public static void setTestMode(boolean test) {
        testMode = test;
        testModeLLM = test;
    }

    public static void setTestModeForLLM(boolean test) {
        testModeLLM = test;
    }

    public static void setFailWithException(boolean fail) {
        failWithException = fail;
    }

    public static boolean isTestMode() {
        return testMode;
    }

    public static boolean istTestModeLLM() {
        return testModeLLM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toolMain(String ... args) throws Exception {
        ActivityReporter.Null defaultReporter;
        ActivityReporter.Stream streamReporter = new ActivityReporter.Stream(System.out);
        ActivityReporter reporter = defaultReporter = new ActivityReporter.Null();
        PrintStream output = null;
        PrintStream reporterOutput = null;
        boolean verbose = false;
        boolean closeOutput = false;
        RuntimeException exc = null;
        try {
            CliTool instance;
            Class<?> clazz;
            ToolDefaultVerbose defVerbose;
            int toolArgNum = 0;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("-")) {
                    switch (args[i]) {
                        case "-vv": {
                            streamReporter.setVerboseSummary(true);
                            reporter = null;
                            verbose = true;
                            break;
                        }
                        case "-v": {
                            verbose = true;
                            break;
                        }
                        case "-q": {
                            reporter = new ActivityReporter.Null();
                            verbose = false;
                            break;
                        }
                        case "-o": {
                            String of = args[++i];
                            closeOutput = true;
                            output = new PrintStream(new File(of), StandardCharsets.UTF_8.name());
                            break;
                        }
                        case "-op": {
                            String opf = args[++i];
                            reporterOutput = new PrintStream(new File(opf), StandardCharsets.UTF_8.name());
                            streamReporter = new ActivityReporter.Stream(reporterOutput);
                            streamReporter.setVerboseSummary(reporter == null);
                            break;
                        }
                        case "--version": {
                            String version = VersionHelper.getVersion().toString();
                            System.out.println(version);
                            return;
                        }
                    }
                    continue;
                }
                toolArgNum = i;
                break;
            }
            if (reporter == null) {
                reporter = streamReporter;
            }
            if (output == null) {
                output = System.out;
            }
            if (args.length <= toolArgNum || this.tools.get(args[toolArgNum]) == null) {
                System.out.println("Usage: $0 [-q|-v|-o <file>] <tool> <args...>");
                System.out.println("  -q      Be quiet - no progress reporting.");
                System.out.println("  -v      Be verbose - show a summary of tasks and durations. No effect if -q is given as well.");
                System.out.println("  -o <f>  Write output to file <f>. No effect on progress output.");
                System.out.println("  -op <f> Write progress tracking output to file <f>. No effect on normal output.");
                System.out.println("  Tools:");
                this.tools.entrySet().stream().forEach(e -> {
                    Configuration.Help h2 = ((Class)e.getValue()).getAnnotation(Configuration.Help.class);
                    if (h2 != null) {
                        System.out.println("  " + String.format("%1$12s: %2$s", e.getKey(), h2.value()));
                    } else {
                        System.out.println("  " + String.format("%1$12s:", e.getKey()));
                    }
                });
                if (failWithException || testMode) {
                    throw new IllegalArgumentException("Wrong number of arguments");
                }
                System.exit(1);
            }
            if (!((defVerbose = (clazz = (instance = this.getTool(Arrays.copyOfRange(args, toolArgNum, args.length))).getClass()).getAnnotation(ToolDefaultVerbose.class)) == null || verbose || verbose && reporter == streamReporter || reporter != defaultReporter)) {
                verbose = true;
                if (defVerbose.value()) {
                    reporter = streamReporter;
                }
            }
            if (reporter == streamReporter) {
                streamReporter.beginReporting();
            }
            instance.setOutput(output);
            instance.setVerbose(verbose);
            instance.setActivityReporter(reporter);
            if (instance instanceof ConfiguredCliTool && ((ConfiguredCliTool)instance).getRawConfiguration().getAllRawObjects().containsKey("help")) {
                ((ConfiguredCliTool)instance).helpAndFail("Help:");
            }
            try (Timer.Context timer = Metrics.getMetric(Metrics.MetricGroup.CLI).timer(instance.getClass().getSimpleName() + "/" + args[toolArgNum]).time();){
                instance.run();
            }
        }
        catch (RuntimeException t) {
            exc = t;
        }
        finally {
            if (closeOutput && output != null) {
                output.close();
            }
            streamReporter.stopReporting();
            if (reporterOutput != null) {
                reporterOutput.close();
            }
        }
        if (failWithException || testMode) {
            if (exc != null) {
                throw exc;
            }
            return;
        }
        if (exc != null) {
            if (output == null) {
                output = System.out;
            }
            if (verbose) {
                exc.printStackTrace(output);
            } else {
                Throwable c = exc;
                while (c != null) {
                    output.println("ERROR: " + c.toString());
                    Throwable next = c.getCause();
                    if (next == c) break;
                    c = next;
                }
            }
            System.exit(1);
        }
        System.exit(0);
    }

    public CliTool getTool(String ... args) throws Exception {
        Class<? extends CliTool> tool = this.tools.get(args[0]);
        CliTool instance = tool.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        if (instance instanceof ConfiguredCliTool) {
            Configuration cfg = new Configuration();
            if (args.length > 1) {
                cfg.add(Arrays.copyOfRange(args, 1, args.length));
            }
            ConfiguredCliTool toConfig = (ConfiguredCliTool)instance;
            toConfig.setConfig(cfg);
        } else if (instance instanceof NativeCliTool) {
            ((NativeCliTool)instance).setArguments(Arrays.copyOfRange(args, 1, args.length));
        }
        return instance;
    }

    public static String nameOf(Class<? extends CliTool> tool) {
        CliTool.CliName name = tool.getAnnotation(CliTool.CliName.class);
        if (name == null || name.value() == null) {
            throw new IllegalStateException("Cannot find annotation on " + tool);
        }
        return name.value();
    }

    protected void register(Class<? extends CliTool> tool) {
        this.tools.put(ToolBase.nameOf(tool), tool);
    }

    @SuppressFBWarnings
    public static abstract class ConfiguredCliTool<T extends Annotation>
    extends CliTool {
        private final Class<T> configClass;
        private Configuration config;

        public ConfiguredCliTool(Class<T> configClass) {
            this.configClass = configClass;
        }

        private void setConfig(Configuration config) {
            this.config = config;
        }

        protected Class<? extends Annotation> getPrimaryConfigClass() {
            return this.configClass;
        }

        protected Collection<Class<? extends Annotation>> getConfigsForHelp() {
            return Collections.singletonList(this.configClass);
        }

        protected <X extends Annotation> X getConfig(Class<X> clazz) {
            try {
                return (X)this.config.get(clazz);
            }
            catch (ConfigValidationException e) {
                this.out().println("Validation Issues Exist:");
                for (Throwable t : e.getSuppressed()) {
                    this.out().println("  " + t.getMessage());
                }
                throw e;
            }
        }

        protected Configuration getRawConfiguration() {
            return this.config;
        }

        @Override
        public final void run() {
            this.run(this.getConfig(this.configClass));
        }

        protected void helpAndFailIfMissing(Object argument, String message) {
            if (argument == null || argument.getClass().isArray() && Array.getLength(argument) == 0 || argument instanceof String && ((String)argument).isEmpty()) {
                this.helpAndFail(message);
            }
        }

        protected void helpAndFail(String message) {
            System.out.println(message);
            System.out.println();
            System.out.println("Usage: " + this.getClass().getSimpleName() + " <args...>");
            for (Class<Annotation> x : this.getConfigsForHelp()) {
                Configuration.formatHelp(x, System.out, "  ");
            }
            if (failWithException || testMode) {
                throw new IllegalArgumentException(message);
            }
            System.exit(1);
        }

        protected abstract void run(T var1);
    }

    public static abstract class NativeCliTool
    extends CliTool {
        private String[] args;

        private void setArguments(String[] args) {
            this.args = args;
        }

        @Override
        public final void run() {
            this.run(this.args);
        }

        protected abstract void run(String[] var1);
    }

    public static abstract class CliTool {
        private ActivityReporter reporter;
        private PrintStream output = System.out;
        private boolean verbose;

        public void setActivityReporter(ActivityReporter reporter) {
            this.reporter = reporter;
        }

        protected ActivityReporter getActivityReporter() {
            return this.reporter;
        }

        public void setOutput(PrintStream output) {
            this.output = output;
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        protected boolean isVerbose() {
            return this.verbose;
        }

        protected PrintStream out() {
            return this.output;
        }

        public abstract void run();

        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.TYPE})
        public static @interface CliName {
            public String value();
        }
    }
}

