/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.security;

import io.bdeploy.common.security.KeyStoreProvider;
import io.bdeploy.common.security.SecurityHelper;
import java.io.IOException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Arrays;

public class OnDiscKeyStore
implements KeyStoreProvider {
    private final char[] pp;
    private final KeyStore ks;

    public OnDiscKeyStore(Path file, String passphrase) {
        this.pp = passphrase.toCharArray();
        try {
            this.ks = SecurityHelper.getInstance().loadPublicKeyStore(file, this.pp);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalStateException("Cannot load keystore from " + file, e);
        }
    }

    @Override
    public KeyStore getStore() {
        return this.ks;
    }

    @Override
    public char[] getPass() {
        return Arrays.copyOf(this.pp, this.pp.length);
    }
}

