/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.bdeploy.common.security.InMemoryKeyStore;
import io.bdeploy.common.security.KeyStoreProvider;
import java.io.Serializable;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;

public class RemoteService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final URI uri;
    private final String authPack;
    private transient KeyStoreProvider provider;

    public RemoteService(URI uri) {
        this.uri = uri;
        this.authPack = null;
        this.provider = null;
    }

    @JsonCreator
    public RemoteService(@JsonProperty(value="uri") URI uri, @JsonProperty(value="authPack") String authPack) {
        this.uri = uri;
        this.authPack = authPack;
    }

    public RemoteService(URI uri, KeyStoreProvider provider) {
        this.uri = uri;
        this.authPack = null;
        this.provider = provider;
    }

    public KeyStoreProvider getKeyStore() {
        if (this.provider == null && this.authPack != null) {
            this.provider = new InMemoryKeyStore(this.authPack);
        }
        return this.provider;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getAuthPack() {
        return this.authPack;
    }

    public URI getWebSocketUri(String path) {
        return UriBuilder.fromUri(this.getUri()).scheme("wss").replacePath("/ws").path(path).build(new Object[0]);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.authPack == null ? 0 : this.authPack.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteService other = (RemoteService)obj;
        if (this.authPack == null ? other.authPack != null : !this.authPack.equals(other.authPack)) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }
}

