/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.security;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class ScopedPermission {
    public final String scope;
    @JsonAlias(value={"capability"})
    public final Permission permission;

    public ScopedPermission(Permission permission) {
        this(null, permission);
    }

    @JsonCreator
    public ScopedPermission(@JsonProperty(value="scope") String scope, @JsonProperty(value="permission") Permission permission) {
        this.scope = scope;
        this.permission = permission;
    }

    public String toString() {
        if (this.scope == null) {
            return this.permission.name() + " (<<GLOBAL>>)";
        }
        return this.permission.name() + " (" + this.scope + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.permission == null ? 0 : this.permission.hashCode());
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScopedPermission other = (ScopedPermission)obj;
        if (this.permission != other.permission) {
            return false;
        }
        return !(this.scope == null ? other.scope != null : !this.scope.equals(other.scope));
    }

    public boolean isGlobal() {
        return this.scope == null;
    }

    public boolean satisfies(ScopedPermission other) {
        if (this.isGlobal()) {
            return this.comparePermission(other.permission) >= 0;
        }
        if (other.isGlobal()) {
            return false;
        }
        if (!this.scope.equals(other.scope)) {
            return false;
        }
        return this.comparePermission(other.permission) >= 0;
    }

    private int comparePermission(Permission other) {
        return Integer.compare(this.permission.level, other.level);
    }

    public static enum Permission {
        READ(1),
        WRITE(2),
        ADMIN(3);

        int level;

        private Permission(int level) {
            this.level = level;
        }
    }
}

