/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.security;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.bdeploy.common.util.JacksonHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityHelper {
    private static final Logger log = LoggerFactory.getLogger(SecurityHelper.class);
    private static final SecurityHelper INSTANCE = new SecurityHelper();
    public static final String ROOT_ALIAS = "1";
    private static final byte[] DEF_SLT = "@%$&".getBytes(StandardCharsets.UTF_8);
    private static final String TOKEN_ALIAS = "token";
    public static final String CERT_ALIAS = "cert";

    private SecurityHelper() {
    }

    public static SecurityHelper getInstance() {
        return INSTANCE;
    }

    public static SecretKeySpec createSecretKey(char[] password) throws GeneralSecurityException {
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
        PBEKeySpec keySpec = new PBEKeySpec(password, DEF_SLT, 1024, 256);
        SecretKey keyTmp = keyFactory.generateSecret(keySpec);
        return new SecretKeySpec(keyTmp.getEncoded(), "AES");
    }

    public static String encrypt(String data, SecretKeySpec key) throws GeneralSecurityException {
        Cipher pbeCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        pbeCipher.init(1, key);
        AlgorithmParameters parameters = pbeCipher.getParameters();
        IvParameterSpec ivParameterSpec = parameters.getParameterSpec(IvParameterSpec.class);
        byte[] cryptoText = pbeCipher.doFinal(data.getBytes(StandardCharsets.UTF_8));
        byte[] iv = ivParameterSpec.getIV();
        return SecurityHelper.encode(iv) + ":" + SecurityHelper.encode(cryptoText);
    }

    public static String decrypt(String data, SecretKeySpec key) throws GeneralSecurityException {
        String iv = data.split(":")[0];
        String property = data.split(":")[1];
        Cipher pbeCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        pbeCipher.init(2, (Key)key, new IvParameterSpec(SecurityHelper.decode(iv)));
        return new String(pbeCipher.doFinal(SecurityHelper.decode(property)), StandardCharsets.UTF_8);
    }

    public <T> String createSignaturePack(T payload, KeyStore keystore, char[] passphrase) throws GeneralSecurityException {
        SignaturePack pack = new SignaturePack();
        pack.t = this.createToken(payload, keystore, passphrase);
        pack.c = SecurityHelper.encode(this.getCertificate(keystore).getEncoded());
        return pack.toString();
    }

    public <T> String createSignaturePack(T payload, Path keystore, char[] passphrase) throws GeneralSecurityException, IOException {
        KeyStore ks = this.loadPrivateKeyStore(keystore, passphrase);
        SignaturePack pack = new SignaturePack();
        pack.t = this.createToken(payload, ks, passphrase);
        pack.c = SecurityHelper.encode(this.getCertificate(ks).getEncoded());
        return pack.toString();
    }

    public <T> String createToken(T payload, KeyStore ks, char[] passphrase) {
        try {
            PrivateKey pk = this.getPrivateKey(ks, passphrase);
            return this.getSignedToken(payload, pk).toString();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public <T> T getVerifiedPayload(String token, Class<T> clazz, KeyStore ks) throws GeneralSecurityException {
        Certificate cert = this.getCertificate(ks);
        SignedPayload t = SignedPayload.parse(token);
        return this.doVerifyPayload(clazz, t, cert);
    }

    public <T> T getSelfVerifiedPayloadFromPack(String token, Class<T> clazz) throws GeneralSecurityException, IOException {
        Certificate cert;
        SignaturePack sp = SignaturePack.parse(token);
        SignedPayload t = SignedPayload.parse(sp.t);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        try (ByteArrayInputStream bais = new ByteArrayInputStream(SecurityHelper.decode(sp.c));){
            cert = cf.generateCertificate(bais);
        }
        return this.doVerifyPayload(clazz, t, cert);
    }

    public String getTokenFromPack(String pack) {
        return SignaturePack.parse(pack).t;
    }

    private <T> T doVerifyPayload(Class<T> clazz, SignedPayload t, Certificate cert) throws GeneralSecurityException {
        T payload;
        byte[] payloadBytes = SecurityHelper.decode(t.p);
        try {
            payload = SecurityHelper.getMapper().readValue(payloadBytes, clazz);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read JSON", e);
        }
        Signature sig = this.getSignatureAlgorithm();
        sig.initVerify(cert.getPublicKey());
        sig.update(payloadBytes);
        if (!sig.verify(SecurityHelper.decode(t.s))) {
            return null;
        }
        return payload;
    }

    public void importSignaturePack(String pack, KeyStore ks, char[] passphrase) throws GeneralSecurityException, IOException {
        Certificate cert;
        SignaturePack sigs = SignaturePack.parse(pack);
        String aliasCert = CERT_ALIAS;
        String aliasToken = TOKEN_ALIAS;
        KeyStore.PasswordProtection pp = passphrase == null ? null : new KeyStore.PasswordProtection(passphrase);
        SecretKeyFactory skf = SecretKeyFactory.getInstance("PBE");
        SecretKey key = skf.generateSecret(new PBEKeySpec(sigs.t.toCharArray()));
        ks.setEntry(aliasToken, new KeyStore.SecretKeyEntry(key), pp);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        try (ByteArrayInputStream bais = new ByteArrayInputStream(SecurityHelper.decode(sigs.c));){
            cert = cf.generateCertificate(bais);
        }
        ks.setCertificateEntry(aliasCert, cert);
    }

    public void importSignaturePack(String pack, Path keystore, char[] passphrase) throws GeneralSecurityException, IOException {
        KeyStore ks = this.loadPublicKeyStore(keystore, passphrase);
        this.importSignaturePack(pack, ks, passphrase);
        try (OutputStream os = Files.newOutputStream(keystore, new OpenOption[0]);){
            ks.store(os, passphrase);
        }
    }

    public String getSignedToken(KeyStore ks, char[] passphrase) throws GeneralSecurityException {
        String aliasToken = TOKEN_ALIAS;
        if (!ks.containsAlias(aliasToken)) {
            throw new IllegalStateException("No access token found in keystore");
        }
        KeyStore.PasswordProtection pp = passphrase == null ? null : new KeyStore.PasswordProtection(passphrase);
        SecretKeyFactory skf = SecretKeyFactory.getInstance("PBE");
        KeyStore.SecretKeyEntry ske = (KeyStore.SecretKeyEntry)ks.getEntry(aliasToken, pp);
        PBEKeySpec spec = (PBEKeySpec)skf.getKeySpec(ske.getSecretKey(), PBEKeySpec.class);
        return new String(spec.getPassword());
    }

    public KeyStore loadPrivateKeyStore(Path keystore, char[] passphrase) throws GeneralSecurityException, IOException {
        try (InputStream is = Files.newInputStream(keystore, new OpenOption[0]);){
            KeyStore keyStore = this.loadPrivateKeyStore(is, passphrase);
            return keyStore;
        }
    }

    public KeyStore loadPrivateKeyStore(InputStream is, char[] passphrase) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(is, passphrase);
        return ks;
    }

    public KeyStore loadPublicKeyStore(Path keystore, char[] passphrase) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("JCEKS");
        if (Files.exists(keystore, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(keystore, new OpenOption[0]);){
                KeyStore keyStore = this.loadPublicKeyStore(is, passphrase);
                return keyStore;
            }
        }
        ks.load(null, passphrase);
        return ks;
    }

    public KeyStore loadPublicKeyStore(InputStream is, char[] passphrase) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("JCEKS");
        ks.load(is, passphrase);
        return ks;
    }

    private PrivateKey getPrivateKey(KeyStore ks, char[] passphrase) throws GeneralSecurityException {
        return (PrivateKey)ks.getKey(ROOT_ALIAS, passphrase);
    }

    private Certificate getCertificate(KeyStore ks) throws KeyStoreException {
        Certificate cert;
        String alias = ROOT_ALIAS;
        if (!ks.containsAlias(ROOT_ALIAS)) {
            alias = CERT_ALIAS;
        }
        if ((cert = ks.getCertificate(alias)) != null) {
            return cert;
        }
        throw new IllegalStateException("KeyStore does not contain a certificate");
    }

    private String getRawSignature(String data, PrivateKey pk) throws GeneralSecurityException {
        Signature rsa = this.getSignatureAlgorithm();
        rsa.initSign(pk);
        rsa.update(data.getBytes(StandardCharsets.UTF_8));
        byte[] signature = rsa.sign();
        return SecurityHelper.encode(signature);
    }

    private Signature getSignatureAlgorithm() throws NoSuchAlgorithmException {
        return Signature.getInstance("SHA256withRSA");
    }

    private SignedPayload getSignedToken(Object payload, PrivateKey pk) throws GeneralSecurityException, IOException {
        String toSign = SecurityHelper.getMapper().writeValueAsString(payload);
        String signature = this.getRawSignature(toSign, pk);
        SignedPayload t = new SignedPayload();
        t.p = SecurityHelper.encode(toSign.getBytes(StandardCharsets.UTF_8));
        t.s = signature;
        return t;
    }

    private static ObjectMapper getMapper() {
        return JacksonHelper.createDefaultObjectMapper();
    }

    private static String encode(byte[] bytes) {
        return Base64.encodeBase64String(bytes);
    }

    private static byte[] decode(String data) {
        return Base64.decodeBase64(data);
    }

    private static class SignaturePack {
        private String c;
        private String t;

        private SignaturePack() {
        }

        public String toString() {
            try {
                return SecurityHelper.encode(SecurityHelper.getMapper().writeValueAsBytes(this));
            }
            catch (JsonProcessingException e) {
                throw new IllegalStateException("Cannot write JSON", e);
            }
        }

        public static SignaturePack parse(String pack) {
            try {
                return SecurityHelper.getMapper().readValue(SecurityHelper.decode(pack), SignaturePack.class);
            }
            catch (IOException e) {
                log.debug("Invalid token supplied", e);
                throw new IllegalStateException("Security token invalid.");
            }
        }
    }

    private static class SignedPayload {
        private String p;
        private String s;

        private SignedPayload() {
        }

        public String toString() {
            try {
                return SecurityHelper.encode(SecurityHelper.getMapper().writeValueAsBytes(this));
            }
            catch (JsonProcessingException e) {
                throw new IllegalStateException("Cannot write JSON", e);
            }
        }

        public static SignedPayload parse(String token) {
            try {
                return SecurityHelper.getMapper().readValue(SecurityHelper.decode(token), SignedPayload.class);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot read JSON", e);
            }
        }
    }
}

