/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.util;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class MdcLogger {
    private static final String MDC_NAME = "BDEPLOY";
    private final Logger logger;
    private Object[] mdcData = new Object[0];

    public MdcLogger(Class<?> clazz) {
        this.logger = LoggerFactory.getLogger(clazz);
    }

    public void setMdcValue(Object ... value) {
        this.mdcData = value;
    }

    public void log(Consumer<Logger> writer) {
        MdcLogger.doLog(this.logger, writer, this.mdcData);
    }

    public void log(Consumer<Logger> writer, Object ... mdcData) {
        Object[] unifiedMdc = Arrays.copyOf(this.mdcData, this.mdcData.length + mdcData.length);
        System.arraycopy(mdcData, 0, unifiedMdc, this.mdcData.length, mdcData.length);
        MdcLogger.doLog(this.logger, writer, unifiedMdc);
    }

    private static void doLog(Logger logger, Consumer<Logger> writer, Object ... mdcData) {
        try {
            MDC.put(MDC_NAME, Joiner.on(" / ").join(mdcData));
            writer.accept(logger);
        }
        finally {
            MDC.clear();
        }
    }
}

