/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.util;

public class OsHelper {
    private OsHelper() {
    }

    public static OperatingSystem getRunningOs() {
        String prop = System.getProperty("os.name").toUpperCase();
        if (prop.contains("WINDOWS")) {
            return OperatingSystem.WINDOWS;
        }
        if (prop.contains("LINUX")) {
            return OperatingSystem.LINUX;
        }
        if (prop.contains("AIX")) {
            return OperatingSystem.AIX;
        }
        if (prop.contains("MAC")) {
            return OperatingSystem.MACOS;
        }
        throw new IllegalStateException("Unsupported OS: " + prop);
    }

    public static enum OperatingSystem {
        WINDOWS,
        LINUX,
        AIX,
        MACOS,
        UNKNOWN;

    }
}

