/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamHelper {
    private StreamHelper() {
    }

    public static long copy(InputStream source, OutputStream sink) throws IOException {
        int n;
        long nread = 0L;
        byte[] buf = new byte[8192];
        while ((n = source.read(buf)) > 0) {
            sink.write(buf, 0, n);
            nread += (long)n;
        }
        return nread;
    }

    public static byte[] read(InputStream source) throws IOException {
        byte[] buf = new byte[8192];
        try (ByteArrayOutputStream sink = new ByteArrayOutputStream();){
            int n;
            while ((n = source.read(buf)) > 0) {
                sink.write(buf, 0, n);
            }
            byte[] byArray = sink.toByteArray();
            return byArray;
        }
    }

    public static boolean isTextFile(InputStream is) throws IOException {
        int b;
        int remainingToCheck = 4096;
        while (remainingToCheck-- > 0 && (b = is.read()) != -1) {
            if (b != 0) continue;
            return false;
        }
        return true;
    }
}

