/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.common.util;

import io.bdeploy.common.util.ShouldResolve;
import io.bdeploy.common.util.VariableResolver;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class TemplateHelper {
    private static final String PATTERN_START = "{{";
    private static final String PATTERN_END = "}}";
    private static final Pattern PATTERN = Pattern.compile(Pattern.quote("{{") + "(.*?)" + Pattern.quote("}}"));

    private TemplateHelper() {
    }

    public static List<String> process(List<String> values, VariableResolver valueResolver) {
        return TemplateHelper.process(values, valueResolver, v -> true);
    }

    public static List<String> process(List<String> values, VariableResolver valueResolver, ShouldResolve shouldResolve) {
        return values.stream().map(v -> TemplateHelper.process(v, valueResolver, shouldResolve)).collect(Collectors.toList());
    }

    public static String process(String value, VariableResolver valueResolver) {
        return TemplateHelper.process(value, valueResolver, v -> true);
    }

    public static String process(String value, VariableResolver valueResolver, ShouldResolve shouldResolve) {
        if (value == null || !value.contains(PATTERN_START)) {
            return value;
        }
        return TemplateHelper.doProcess(value, valueResolver, shouldResolve);
    }

    private static String doProcess(String value, VariableResolver valueResolver, ShouldResolve shouldResolve) {
        StringBuilder builder = new StringBuilder();
        int currentStart = 0;
        Matcher m3 = PATTERN.matcher(value);
        while (m3.find()) {
            String nextMatch;
            String resolved = nextMatch = m3.group(1);
            if (shouldResolve != null && ((Boolean)shouldResolve.apply(nextMatch)).booleanValue()) {
                resolved = (String)valueResolver.apply(nextMatch);
                if (resolved == null) {
                    throw new IllegalArgumentException("Cannot find replacement for variable " + nextMatch + " while processing " + value);
                }
                resolved = TemplateHelper.doProcess(resolved, valueResolver, shouldResolve);
            } else {
                resolved = PATTERN_START + resolved + PATTERN_END;
            }
            builder.append(value.substring(currentStart, m3.start()));
            builder.append(resolved);
            currentStart = m3.end();
        }
        builder.append(value.substring(currentStart, value.length()));
        return builder.toString();
    }
}

