/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey;

import io.bdeploy.jersey.JerseyCorsFilter;
import io.bdeploy.jersey.activity.JerseyBroadcastingActivityReporter;
import io.bdeploy.jersey.audit.AuditRecord;
import io.bdeploy.jersey.audit.Auditor;
import java.io.IOException;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;

@Provider
public class JerseyAuditingFilter
implements ContainerResponseFilter {
    @Inject
    Auditor auditor;

    @Override
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (JerseyCorsFilter.isPreflightRequest(requestContext)) {
            return;
        }
        Response.StatusType status = responseContext.getStatusInfo();
        if (status.getFamily() == Response.Status.Family.SUCCESSFUL && requestContext.getMethod().equals("GET")) {
            return;
        }
        this.auditor.audit(AuditRecord.Builder.fromRequest(requestContext).setSeverity(responseContext.getStatus() > 400 ? AuditRecord.Severity.WARNING : AuditRecord.Severity.NORMAL).setMessage(status.getStatusCode() + ": " + status.getReasonPhrase()).build());
        JerseyBroadcastingActivityReporter.resetThread();
    }
}

