/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey;

import com.fasterxml.jackson.databind.Module;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.ws.WebSocket;
import com.ning.http.client.ws.WebSocketUpgradeHandler;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.security.RemoteService;
import io.bdeploy.common.security.SecurityHelper;
import io.bdeploy.jersey.JerseyGZipFilter;
import io.bdeploy.jersey.JerseyObjectMapper;
import io.bdeploy.jersey.JerseyPathReader;
import io.bdeploy.jersey.JerseyPathWriter;
import io.bdeploy.jersey.activity.JerseyRemoteActivityScopeClientFilter;
import io.bdeploy.jersey.ws.WebSocketAuthenticatingMessageListener;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.ws.rs.Path;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.client.proxy.WebResourceFactory;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.message.GZipEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JerseyClientFactory {
    private static final Logger log;
    private SSLContext sslContext;
    private String bearer;
    private final RemoteService svc;
    private ActivityReporter reporter = new ActivityReporter.Null();
    private final Set<Module> additionalModules = new HashSet<Module>();
    private WebTarget cachedTarget;
    private static final ThreadLocal<String> proxyUuid;
    private static final Cache<RemoteService, JerseyClientFactory> factoryCache;

    private JerseyClientFactory(RemoteService svc) {
        this.svc = svc;
        try {
            SecurityHelper sec = SecurityHelper.getInstance();
            this.bearer = sec.getSignedToken(svc.getKeyStore().getStore(), svc.getKeyStore().getPass());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(svc.getKeyStore().getStore());
            this.sslContext = SSLContext.getInstance("TLS");
            this.sslContext.init(null, tmf.getTrustManagers(), null);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Cannot initialize security", e);
        }
    }

    public static JerseyClientFactory get(RemoteService svc) {
        try {
            return factoryCache.get(svc, () -> new JerseyClientFactory(svc));
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Cannot create/get client factory", e);
        }
    }

    public synchronized void register(Module o) {
        if (this.additionalModules.contains(o)) {
            return;
        }
        this.cachedTarget = null;
        this.additionalModules.add(o);
    }

    public void setReporter(ActivityReporter reporter) {
        this.reporter = reporter;
    }

    SSLContext getSslContext() {
        return this.sslContext;
    }

    public <T> T getProxyClient(Class<T> clazz, Object ... additionalRegistrations) {
        Path path = clazz.getAnnotation(Path.class);
        if (path == null) {
            log.error("Resource '{}' does not have a @Path annotation.Seems to be a sub-resource that needs to be queried via a parent resource.", (Object)clazz);
        }
        return WebResourceFactory.newResource(clazz, this.getBaseTarget(additionalRegistrations));
    }

    public synchronized WebTarget getBaseTarget(Object ... additionalRegistrations) {
        if (additionalRegistrations.length == 0 && this.cachedTarget != null) {
            return this.cachedTarget;
        }
        ClientBuilder builder = ClientBuilder.newBuilder();
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        builder.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.CHUNKED);
        builder.sslContext(this.sslContext);
        builder.hostnameVerifier((h2, s2) -> true);
        builder.register(new JerseyObjectMapper(this.additionalModules));
        builder.register(GZipEncoder.class);
        builder.register(JerseyGZipFilter.class);
        builder.register(JacksonFeature.class);
        builder.register(MultiPartFeature.class);
        builder.register(new ClientBearerFilter(this.bearer));
        builder.register(JerseyPathReader.class);
        builder.register(JerseyPathWriter.class);
        builder.register(new JerseyClientReporterResolver());
        builder.register(new JerseyRemoteActivityScopeClientFilter(proxyUuid::get));
        for (Object reg : additionalRegistrations) {
            if (reg instanceof Class) {
                builder.register((Class)reg);
                continue;
            }
            builder.register(reg);
        }
        WebTarget target = builder.build().target(this.svc.getUri());
        if (additionalRegistrations.length == 0) {
            this.cachedTarget = target;
        }
        return target;
    }

    public static void setProxyUuid(String uuid) {
        if (uuid == null) {
            proxyUuid.remove();
        } else {
            proxyUuid.set(uuid);
        }
    }

    public static String getProxyUuid() {
        return proxyUuid.get();
    }

    public AsyncHttpClient getWebSocketClient() {
        return new AsyncHttpClient(new AsyncHttpClientConfig.Builder().setAcceptAnyCertificate(true).build());
    }

    public ListenableFuture<WebSocket> getAuthenticatedWebSocket(AsyncHttpClient client, List<String> scope, String path, Consumer<byte[]> onMessage, Consumer<Throwable> onError, Consumer<WebSocket> onClose) {
        return client.prepareGet(this.svc.getWebSocketUri(path).toString()).execute(new WebSocketUpgradeHandler.Builder().addWebSocketListener(new WebSocketAuthenticatingMessageListener(SecurityHelper.getInstance().getTokenFromPack(this.svc.getAuthPack()), scope, onMessage, onError, onClose)).build());
    }

    static {
        HttpsURLConnection.getDefaultSSLSocketFactory();
        log = LoggerFactory.getLogger(JerseyClientFactory.class);
        proxyUuid = new ThreadLocal();
        factoryCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(5L, TimeUnit.MINUTES).build();
    }

    @Provider
    private final class JerseyClientReporterResolver
    implements ContextResolver<ActivityReporter> {
        private JerseyClientReporterResolver() {
        }

        @Override
        public ActivityReporter getContext(Class<?> type) {
            return JerseyClientFactory.this.reporter;
        }
    }

    @Provider
    private static class ClientBearerFilter
    implements ClientRequestFilter {
        private final String bearerToken;

        public ClientBearerFilter(String bearerToken) {
            this.bearerToken = bearerToken;
        }

        @Override
        public void filter(ClientRequestContext requestContext) throws IOException {
            requestContext.getHeaders().add("Authorization", "Bearer " + this.bearerToken);
        }
    }
}

