/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey;

import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;

@Provider
@PreMatching
public class JerseyCorsFilter
implements ContainerResponseFilter,
ContainerRequestFilter {
    @Override
    public void filter(ContainerRequestContext request) throws IOException {
        if (JerseyCorsFilter.isPreflightRequest(request)) {
            request.abortWith(Response.ok().build());
        }
    }

    static boolean isPreflightRequest(ContainerRequestContext request) {
        return request.getHeaderString("Origin") != null && request.getMethod().equalsIgnoreCase("OPTIONS");
    }

    @Override
    public void filter(ContainerRequestContext request, ContainerResponseContext response) throws IOException {
        String origin = request.getHeaderString("Origin");
        if (origin == null) {
            return;
        }
        if (origin.contains("localhost")) {
            if (JerseyCorsFilter.isPreflightRequest(request)) {
                response.getHeaders().add("Access-Control-Allow-Credentials", "true");
                response.getHeaders().add("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE, OPTIONS, HEAD");
                response.getHeaders().add("Access-Control-Allow-Headers", "X-Requested-With, Authorization, Accept-Version, Content-Type, Content-MD5, CSRF-Token, X-No-Global-Error-Handling, X-Proxy-Activity-Scope, X-On-Behalf-Of");
            }
            response.getHeaders().add("Access-Control-Allow-Origin", origin);
        }
    }
}

