/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey;

import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.ExceptionHelper;
import io.bdeploy.jersey.activity.JerseyBroadcastingActivityReporter;
import java.lang.reflect.InvocationTargetException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class JerseyExceptionMapper
implements ExceptionMapper<RuntimeException> {
    private static final Logger log = LoggerFactory.getLogger(JerseyExceptionMapper.class);

    @Override
    public Response toResponse(RuntimeException exception) {
        JerseyBroadcastingActivityReporter.resetThread();
        if (exception instanceof WebApplicationException && (exception.getCause() == null || exception.getCause() == exception)) {
            WebApplicationException webEx = (WebApplicationException)exception;
            if (webEx.getResponse().getStatus() == Response.Status.TEMPORARY_REDIRECT.getStatusCode()) {
                return webEx.getResponse();
            }
            return Response.status(webEx.getResponse().getStatus(), webEx.getMessage()).build();
        }
        if (this.hasCancelException(exception)) {
            return Response.status(444, "Operation cancelled by user.").build();
        }
        int code = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
        if (!(exception instanceof WebApplicationException)) {
            log.warn("Unmapped Exception", exception);
        } else {
            code = ((WebApplicationException)exception).getResponse().getStatus();
        }
        return Response.status(code, ExceptionHelper.mapExceptionCausesToReason(exception)).build();
    }

    private boolean hasCancelException(Throwable e) {
        while (e != null) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            if (e instanceof ActivityReporter.ActivityCancelledException) {
                return true;
            }
            Throwable parent = e.getCause();
            if (parent == null || parent == e) {
                return false;
            }
            e = parent;
        }
        return false;
    }
}

