/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey;

import io.bdeploy.common.ActivityReporter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JerseyStreamingHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamWithProgress(ActivityReporter reporter, StreamDirection direction, InputStream in, OutputStream out, long length) throws IOException {
        long maxWork = Math.max(0L, length) / 1024L;
        ActivityReporter.Activity stream = reporter.start((direction == StreamDirection.READ ? "Reading... " : "Writing... ") + " (" + maxWork + "KB)...", maxWork);
        try {
            int l;
            byte[] buffer = new byte[8192];
            for (long remaining = length <= 0L ? Long.MAX_VALUE : length; remaining > 0L; remaining -= (long)l) {
                l = in.read(buffer, 0, (int)Math.min(8192L, remaining));
                if (l == -1) {
                    break;
                }
                out.write(buffer, 0, l);
                stream.workAndCancelIfRequested(1L);
            }
        }
        finally {
            stream.done();
        }
    }

    public static enum StreamDirection {
        READ,
        WRITE;

    }
}

