/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jvnet.hk2.annotations.Service;

@Service
public class JerseyWriteLockService {
    private final Map<String, ReadWriteLock> locks = new TreeMap<String, ReadWriteLock>();

    public ReadWriteLock getLock(String id) {
        return this.locks.computeIfAbsent(id, k -> new ReentrantReadWriteLock());
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface WriteLock {
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface LockingResource {
        public String value() default "";
    }
}

