/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey.activity;

import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.ActivitySnapshot;
import io.bdeploy.common.NoThrowAutoCloseable;
import io.bdeploy.common.security.RemoteService;
import io.bdeploy.jersey.JerseyScopeService;
import io.bdeploy.jersey.activity.JerseyRemoteActivity;
import io.bdeploy.jersey.activity.JerseyRemoteActivityProxy;
import io.bdeploy.jersey.activity.JerseyRemoteActivityScopeServerFilter;
import io.bdeploy.jersey.ws.JerseyEventBroadcaster;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class JerseyBroadcastingActivityReporter
implements ActivityReporter {
    public static final String ACTIVITY_BROADCASTER = "JerseyActivityBroadcaster";
    private static final Logger log = LoggerFactory.getLogger(JerseyBroadcastingActivityReporter.class);
    static final ThreadLocal<JerseyRemoteActivity> currentActivity = new ThreadLocal();
    @Inject
    private JerseyScopeService jss;
    @Inject
    @Named(value="JerseyActivityBroadcaster")
    @Optional
    private JerseyEventBroadcaster bc;
    private final Set<List<String>> activeScopes = new TreeSet<List<String>>(this::compareScopes);
    private final List<JerseyRemoteActivity> globalActivities = new ArrayList<JerseyRemoteActivity>();

    private int compareScopes(List<String> a, List<String> b) {
        if (a.size() > b.size()) {
            return 1;
        }
        if (b.size() > a.size()) {
            return -1;
        }
        for (int i = 0; i < a.size(); ++i) {
            int r = a.get(i).compareTo(b.get(i));
            if (r == 0) continue;
            return r;
        }
        return 0;
    }

    public static void resetThread() {
        currentActivity.remove();
    }

    @Inject
    public JerseyBroadcastingActivityReporter(@Named(value="BcExecutor") ScheduledExecutorService scheduler) {
        scheduler.scheduleAtFixedRate(this::sendUpdate, 1L, 1L, TimeUnit.SECONDS);
    }

    private void sendUpdate() {
        if (this.bc == null) {
            return;
        }
        List<ActivitySnapshot> list = this.getGlobalActivities().stream().filter(Objects::nonNull).map(JerseyRemoteActivity::snapshot).collect(Collectors.toList());
        TreeMap<List, List> perScope = new TreeMap<List, List>(this::compareScopes);
        for (ActivitySnapshot activitySnapshot : list) {
            List forScope = perScope.computeIfAbsent(activitySnapshot.scope, k -> new ArrayList());
            forScope.add(activitySnapshot);
            while (this.addChildren(forScope, list) != 0) {
            }
        }
        this.activeScopes.addAll(perScope.keySet());
        for (Map.Entry entry : perScope.entrySet()) {
            this.bc.send(entry.getValue(), (List)entry.getKey());
        }
        ArrayList<List<String>> scopesToRemove = new ArrayList<List<String>>();
        for (List<String> active : this.activeScopes) {
            if (perScope.containsKey(active)) continue;
            scopesToRemove.add(active);
        }
        for (List toRemove : scopesToRemove) {
            this.activeScopes.remove(toRemove);
            this.bc.send(Collections.emptyList(), toRemove);
        }
    }

    private int addChildren(List<ActivitySnapshot> activities, List<ActivitySnapshot> pool) {
        Set haveUuids = activities.stream().map(s2 -> s2.uuid).collect(Collectors.toCollection(TreeSet::new));
        ArrayList<ActivitySnapshot> children = new ArrayList<ActivitySnapshot>();
        for (ActivitySnapshot root : activities) {
            for (ActivitySnapshot potentialChild : pool) {
                if (haveUuids.contains(potentialChild.uuid) || potentialChild.parentUuid == null || !potentialChild.parentUuid.equals(root.uuid)) continue;
                children.add(potentialChild);
            }
        }
        activities.addAll(children);
        return children.size();
    }

    @Override
    public ActivityReporter.Activity start(String activity) {
        return this.start(activity, -1L);
    }

    @Override
    public ActivityReporter.Activity start(String activity, long maxWork) {
        return this.start(activity, () -> maxWork, null);
    }

    @Override
    public synchronized ActivityReporter.Activity start(String activity, LongSupplier maxValue, LongSupplier currentValue) {
        List<String> scope = JerseyRemoteActivityScopeServerFilter.getRequestActivityScope(this.jss);
        String user = this.jss.getUser();
        JerseyRemoteActivity act = new JerseyRemoteActivity(this::done, activity, maxValue, currentValue, scope, user);
        this.globalActivities.add(act);
        return act;
    }

    private synchronized void done(JerseyRemoteActivity act) {
        if (!this.globalActivities.contains(act)) {
            return;
        }
        JerseyRemoteActivity current = currentActivity.get();
        if (current != null && current.getUuid().equals(act.getUuid())) {
            if (act.getParentUuid() != null) {
                JerseyRemoteActivity parent = this.globalActivities.stream().filter(Objects::nonNull).filter(a -> a.getUuid().equals(act.getParentUuid())).findFirst().orElse(null);
                if (parent != null) {
                    currentActivity.set(parent);
                } else {
                    log.debug("Parent activity no longer available: {}", (Object)act);
                }
            } else {
                currentActivity.remove();
            }
        } else if (current != null) {
            log.warn("Finished activity is not current for this thread: {}, current: {}", (Object)act, (Object)current);
        } else {
            log.warn("Finished activity but there is no current activity for this thread: {}", (Object)act);
        }
        this.globalActivities.remove(act);
    }

    @Override
    public NoThrowAutoCloseable proxyActivities(RemoteService service) {
        return new JerseyRemoteActivityProxy(service, this);
    }

    synchronized List<JerseyRemoteActivity> getGlobalActivities() {
        return new ArrayList<JerseyRemoteActivity>(this.globalActivities);
    }

    synchronized void addProxyActivity(JerseyRemoteActivity act) {
        this.globalActivities.add(act);
    }

    synchronized void removeProxyActivity(JerseyRemoteActivity act) {
        this.globalActivities.remove(act);
    }

    JerseyRemoteActivity getCurrentActivity() {
        return currentActivity.get();
    }

    JerseyRemoteActivity getActivityById(String uuid) {
        return this.globalActivities.stream().filter(Objects::nonNull).filter(a -> a.getUuid().equals(uuid)).findAny().orElse(null);
    }
}

