/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey.activity;

import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.ActivitySnapshot;
import io.bdeploy.common.util.UuidHelper;
import io.bdeploy.jersey.activity.JerseyBroadcastingActivityReporter;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JerseyRemoteActivity
implements ActivityReporter.Activity {
    private static final Logger log = LoggerFactory.getLogger(JerseyRemoteActivity.class);
    private final String name;
    private final Consumer<JerseyRemoteActivity> onDone;
    private final Consumer<JerseyRemoteActivity> onCancel;
    private final LongSupplier maxWork;
    private final LongSupplier currentWork;
    private final long start;
    private final String uuid;
    private String parentUuid;
    private final List<String> scope;
    private long stop = 0L;
    private boolean cancel = false;
    private final LongAdder localCurrent = new LongAdder();
    private final String user;

    public JerseyRemoteActivity(Consumer<JerseyRemoteActivity> onDone, String name, LongSupplier maxWork, LongSupplier currentWork, List<String> scope, String user) {
        this.onDone = onDone;
        this.name = name;
        this.maxWork = maxWork;
        this.currentWork = currentWork != null ? currentWork : this.localCurrent::sum;
        this.start = System.currentTimeMillis();
        this.uuid = UuidHelper.randomId();
        this.scope = scope;
        this.user = user;
        this.onCancel = null;
        JerseyRemoteActivity parent = JerseyBroadcastingActivityReporter.currentActivity.get();
        if (parent != null) {
            this.parentUuid = parent.uuid;
        }
        JerseyBroadcastingActivityReporter.currentActivity.set(this);
        if (log.isTraceEnabled()) {
            log.trace("Begin: [{}] {}", (Object)this.uuid, (Object)name);
        }
    }

    JerseyRemoteActivity(Consumer<JerseyRemoteActivity> onDone, Consumer<JerseyRemoteActivity> onCancel, String name, LongSupplier maxWork, LongSupplier currentWork, List<String> scope, String user, long start, String uuid, String parentUuid) {
        this.onDone = onDone;
        this.onCancel = onCancel;
        this.name = name;
        this.maxWork = maxWork;
        this.currentWork = currentWork;
        this.start = start;
        this.uuid = uuid;
        this.scope = scope;
        this.user = user;
        this.parentUuid = parentUuid;
    }

    @Override
    public void worked(long amount) {
        this.localCurrent.add(amount);
    }

    @Override
    public void done() {
        this.stop = System.currentTimeMillis();
        this.onDone.accept(this);
        if (log.isTraceEnabled()) {
            log.trace("Done: [{}] {}. Duration: {} ms", this.uuid, this.name, this.duration());
        }
    }

    @Override
    public long duration() {
        if (this.stop == 0L) {
            return 0L;
        }
        return this.stop - this.start;
    }

    @Override
    public boolean isCancelRequested() {
        return this.cancel;
    }

    void requestCancel() {
        this.cancel = true;
        if (this.onCancel != null) {
            this.onCancel.accept(this);
        }
        if (log.isTraceEnabled()) {
            log.trace("Cancel: [{}] {}, duration: {} ms", this.uuid, this.name, this.duration());
        }
    }

    String getUuid() {
        return this.uuid;
    }

    String getParentUuid() {
        return this.parentUuid;
    }

    String getUser() {
        return this.user;
    }

    public String toString() {
        return "[" + this.uuid + "] " + this.name;
    }

    ActivitySnapshot snapshot() {
        return new ActivitySnapshot(this.uuid, this.name, this.stop != 0L ? this.duration() : System.currentTimeMillis() - this.start, this.maxWork.getAsLong(), this.currentWork.getAsLong(), this.scope, this.cancel, this.parentUuid, this.user);
    }
}

