/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey.activity;

import com.google.common.base.Splitter;
import io.bdeploy.jersey.ActivityScope;
import io.bdeploy.jersey.JerseyScopeService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.model.Parameter;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.model.ResourceMethod;

@Provider
public class JerseyRemoteActivityScopeServerFilter
implements ContainerRequestFilter {
    @Inject
    private javax.inject.Provider<MultivaluedParameterExtractorProvider> mpep;
    @Inject
    private JerseyScopeService scopeService;

    @Override
    public void filter(ContainerRequestContext requestContext) throws IOException {
        UriInfo plainInfo = requestContext.getUriInfo();
        if (plainInfo instanceof ExtendedUriInfo) {
            ArrayList<String> scope = new ArrayList<String>();
            String proxyScope = requestContext.getHeaderString("X-Proxy-Activity-Scope");
            if (proxyScope != null) {
                if (proxyScope.contains(",")) {
                    scope.addAll(Splitter.on(',').splitToList(proxyScope));
                } else {
                    scope.add(proxyScope);
                }
            }
            ExtendedUriInfo info = (ExtendedUriInfo)plainInfo;
            ArrayList<ResourceMethod> methods = new ArrayList<ResourceMethod>(info.getMatchedResourceLocators());
            Collections.reverse(methods);
            methods.add(info.getMatchedResourceMethod());
            for (ResourceMethod m3 : methods) {
                scope.addAll(this.getMethodScope(info, m3));
            }
            String user = "<unknown>";
            SecurityContext securityContext = requestContext.getSecurityContext();
            if (securityContext != null && securityContext.getUserPrincipal() != null) {
                user = securityContext.getUserPrincipal().getName();
            }
            this.scopeService.setScope(scope, user);
        }
    }

    private List<String> getMethodScope(ExtendedUriInfo info, ResourceMethod m3) {
        ArrayList<String> scopesInOrder = new ArrayList<String>();
        for (Parameter param : m3.getInvocable().getParameters()) {
            MultivaluedMap<String, String> parameters;
            if (param.getAnnotation(ActivityScope.class) == null) continue;
            if (param.getSource() != Parameter.Source.PATH && param.getSource() != Parameter.Source.QUERY) {
                throw new IllegalStateException("ActivityScope can only be annotated on QueryParam or PathParam: " + m3);
            }
            MultivaluedMap<String, String> multivaluedMap = parameters = param.getSource() == Parameter.Source.QUERY ? info.getQueryParameters() : info.getPathParameters();
            Object value = this.mpep.get().get(param).extract(parameters);
            if (value == null) continue;
            scopesInOrder.add(value.toString());
        }
        return scopesInOrder;
    }

    public static List<String> getRequestActivityScope(JerseyScopeService jss) {
        if (jss == null) {
            return Collections.emptyList();
        }
        List<String> result = jss.getScope();
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }
}

