/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey.audit;

import io.bdeploy.jersey.audit.AuditRecord;
import io.bdeploy.jersey.audit.Auditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class Log4jAuditor
implements Auditor {
    private static final Logger log = LoggerFactory.getLogger(Log4jAuditor.class);

    @Override
    public void close() {
    }

    @Override
    public void audit(AuditRecord record) {
        MDC.put("WHO", record.who);
        MDC.put("WHAT", record.what);
        MDC.put("PARAMETERS", record.parameters);
        MDC.put("METHOD", record.method);
        switch (record.severity) {
            case NORMAL: {
                log.info(record.message);
                break;
            }
            case WARNING: {
                log.warn(record.message);
                break;
            }
            case ERROR: {
                log.error(record.message);
            }
        }
    }
}

