/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey.audit;

import io.bdeploy.jersey.audit.AuditRecord;
import io.bdeploy.jersey.audit.Auditor;
import java.nio.file.Path;
import java.util.ArrayList;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.impl.ContextDataFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.layout.AbstractJacksonLayout;
import org.apache.logging.log4j.core.layout.JsonLayout;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.util.StringMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollingFileAuditor
implements Auditor {
    private static final Logger log = LoggerFactory.getLogger(RollingFileAuditor.class);
    public static final String LOG_PATTERN = "%d{dd-HH:mm:ss.SSS} | %-5level | AUD/%-11X{WHO} | %-7X{METHOD} | %-40X{WHAT} | %-40msg | %X{PARAMETERS}%n";
    public static final int LOG_MAX_INDEX = 3;
    public static final String LOG_TXT_FILENAME = "audit.log";
    public static final String LOG_TXT_FILEPATTERN = "audit-%i.log.gz";
    public static final String LOG_JSON_FILENAME = "audit.json";
    public static final String LOG_JSON_FILEPATTERN = "audit-%i.json.gz";
    private final Path logDir;
    private final RollingFileAppender logAppender;
    private final RollingFileAppender jsonAppender;

    public RollingFileAuditor(Path logDir) {
        this.logDir = logDir;
        this.logAppender = this.createFileAppender(logDir);
        this.jsonAppender = this.createJsonAppender(logDir);
    }

    public String toString() {
        return "RollingFileAuditor [" + this.logDir + "]";
    }

    @Override
    public void audit(AuditRecord record) {
        try {
            if (this.logAppender.isStopped() || this.jsonAppender.isStopped()) {
                return;
            }
            Log4jLogEvent.Builder builder = Log4jLogEvent.newBuilder();
            builder.setMessage(new SimpleMessage(record.message));
            switch (record.severity) {
                case NORMAL: {
                    builder.setLevel(Level.INFO);
                    break;
                }
                case WARNING: {
                    builder.setLevel(Level.WARN);
                    break;
                }
                case ERROR: {
                    builder.setLevel(Level.ERROR);
                }
            }
            StringMap contextData = ContextDataFactory.createContextData();
            contextData.putValue("WHO", record.who);
            contextData.putValue("WHAT", record.what);
            contextData.putValue("PARAMETERS", record.parameters);
            contextData.putValue("METHOD", record.method);
            builder.setContextData(contextData);
            Log4jLogEvent logEvent = builder.build();
            this.jsonAppender.append(logEvent);
            this.logAppender.append(logEvent);
        }
        catch (Exception e) {
            log.error("Cannot write audit log", e);
        }
    }

    @Override
    public void close() {
        if (this.logAppender != null) {
            this.logAppender.stop();
        }
        if (this.jsonAppender != null) {
            this.jsonAppender.stop();
        }
    }

    public Path getJsonFile() {
        return this.logDir.resolve(this.jsonAppender.getFileName());
    }

    public Path[] getJsonBackups() {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (int i = 1; i <= 3; ++i) {
            Path p = this.logDir.resolve(this.jsonAppender.getFilePattern().replace("%i", "" + i));
            if (!p.toFile().exists()) continue;
            paths.add(p);
        }
        return paths.toArray(new Path[0]);
    }

    public Path getLogFile() {
        return this.logDir.resolve(((RollingFileManager)this.logAppender.getManager()).getFileName());
    }

    private RollingFileAppender createFileAppender(Path logDir) {
        Object builder = RollingFileAppender.newBuilder();
        ((AbstractAppender.Builder)builder).setName("auditLogger");
        ((RollingFileAppender.Builder)builder).withFileName(logDir.resolve(LOG_TXT_FILENAME).toString());
        ((RollingFileAppender.Builder)builder).withFilePattern(logDir.resolve(LOG_TXT_FILEPATTERN).toString());
        ((RollingFileAppender.Builder)builder).withPolicy(SizeBasedTriggeringPolicy.createPolicy("5M"));
        ((AbstractAppender.Builder)builder).setLayout(PatternLayout.newBuilder().withPattern(LOG_PATTERN).build());
        ((RollingFileAppender.Builder)builder).withStrategy(DefaultRolloverStrategy.newBuilder().withCompressionLevelStr(String.valueOf(-1)).withMax(Integer.toString(3)).build());
        return ((RollingFileAppender.Builder)builder).build();
    }

    private RollingFileAppender createJsonAppender(Path logDir) {
        ArrayList<KeyValuePair> fields = new ArrayList<KeyValuePair>();
        fields.add(KeyValuePair.newBuilder().setKey("who").setValue("${ctx:WHO}").build());
        fields.add(KeyValuePair.newBuilder().setKey("what").setValue("${ctx:WHAT}").build());
        fields.add(KeyValuePair.newBuilder().setKey("method").setValue("${ctx:METHOD}").build());
        fields.add(KeyValuePair.newBuilder().setKey("parameters").setValue("${ctx:PARAMETERS}").build());
        Object builder = RollingFileAppender.newBuilder();
        ((AbstractAppender.Builder)builder).setName("auditJsonLogger");
        ((RollingFileAppender.Builder)builder).withFileName(logDir.resolve(LOG_JSON_FILENAME).toString());
        ((RollingFileAppender.Builder)builder).withFilePattern(logDir.resolve(LOG_JSON_FILEPATTERN).toString());
        ((RollingFileAppender.Builder)builder).withPolicy(SizeBasedTriggeringPolicy.createPolicy("10M"));
        ((AbstractAppender.Builder)builder).setLayout(((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((AbstractJacksonLayout.Builder)JsonLayout.newBuilder()).setCompact(true)).setEventEol(true)).setConfiguration(new DefaultConfiguration())).setAdditionalFields(fields.toArray(new KeyValuePair[0]))).build());
        ((RollingFileAppender.Builder)builder).withStrategy(DefaultRolloverStrategy.newBuilder().withCompressionLevelStr(String.valueOf(-1)).withMax(Integer.toString(3)).build());
        return ((RollingFileAppender.Builder)builder).build();
    }
}

