/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey.cli;

import io.bdeploy.common.security.RemoteService;
import io.bdeploy.common.util.JacksonHelper;
import io.bdeploy.jersey.TrustAllServersTrustManager;
import io.bdeploy.jersey.cli.LocalLoginData;
import io.bdeploy.jersey.cli.LocalLoginServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalLoginManager {
    private static final Logger log = LoggerFactory.getLogger(LocalLoginManager.class);
    private final Path home;

    public LocalLoginManager(Path home) {
        this.home = home;
    }

    public LocalLoginManager() {
        this(Paths.get(System.getProperty("user.home"), new String[0]).resolve(".bdeploy"));
    }

    private Path getDataFile() {
        return this.home.resolve(".bdeploy_login");
    }

    private void write(LocalLoginData data) {
        try {
            if (!Files.isRegularFile(this.getDataFile(), new LinkOption[0])) {
                Files.createDirectories(this.getDataFile().getParent(), new FileAttribute[0]);
                Files.createFile(this.getDataFile(), new FileAttribute[0]);
            }
            try (OutputStream os = Files.newOutputStream(this.getDataFile(), new OpenOption[0]);){
                JacksonHelper.createObjectMapper(JacksonHelper.MapperType.JSON).writeValue(os, (Object)data);
            }
        }
        catch (IOException e) {
            log.error("Cannot write local login data to {}", (Object)this.getDataFile(), (Object)e);
        }
    }

    public LocalLoginData read() {
        LocalLoginData localLoginData;
        block9: {
            if (!Files.isRegularFile(this.getDataFile(), new LinkOption[0])) {
                return new LocalLoginData();
            }
            InputStream is = Files.newInputStream(this.getDataFile(), new OpenOption[0]);
            try {
                localLoginData = JacksonHelper.createObjectMapper(JacksonHelper.MapperType.JSON).readValue(is, LocalLoginData.class);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("Cannot read local login data from {}", (Object)this.getDataFile(), (Object)e);
                    return new LocalLoginData();
                }
            }
            is.close();
        }
        return localLoginData;
    }

    public void login(String serverName, String url, String user, String password) {
        LocalLoginData data = this.read();
        if (data.servers.containsKey(serverName)) {
            throw new IllegalStateException("Server with name " + serverName + " already exists.");
        }
        AuthDto auth = new AuthDto();
        auth.user = user;
        auth.password = password;
        ClientBuilder builder = ClientBuilder.newBuilder().hostnameVerifier((h2, s2) -> true).sslContext(this.createTrustAllContext());
        Response result = builder.build().target(url).path("/auth/packed").request().post(Entity.entity(auth, "application/json"));
        if (result.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw new IllegalStateException("Failed to login: " + result.getStatusInfo().getReasonPhrase());
        }
        LocalLoginServer s3 = new LocalLoginServer();
        s3.url = url;
        s3.token = result.readEntity(String.class);
        s3.user = user;
        data.servers.put(serverName, s3);
        data.current = serverName;
        this.write(data);
    }

    public void remove(String serverName) {
        LocalLoginData data = this.read();
        data.servers.remove(serverName);
        if (serverName.equals(data.current)) {
            data.current = null;
        }
        this.write(data);
    }

    public void setCurrent(String serverName) {
        LocalLoginData data = this.read();
        if (!data.servers.containsKey(serverName)) {
            throw new IllegalStateException("Unknown server: " + serverName);
        }
        data.current = serverName;
        this.write(data);
    }

    public String getCurrent() {
        return this.read().current;
    }

    public RemoteService getCurrentService() {
        LocalLoginData data = this.read();
        if (data.current == null) {
            return null;
        }
        return this.getNamedService(data.current);
    }

    public RemoteService getNamedService(String name) {
        LocalLoginData data = this.read();
        if (!data.servers.containsKey(name)) {
            return null;
        }
        LocalLoginServer server = (LocalLoginServer)data.servers.get(name);
        return new RemoteService(UriBuilder.fromUri(server.url).build(new Object[0]), server.token);
    }

    private SSLContext createTrustAllContext() {
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, new TrustManager[]{new TrustAllServersTrustManager()}, new SecureRandom());
            return sslcontext;
        }
        catch (GeneralSecurityException e) {
            log.warn("Cannot create SSL context", e);
            return null;
        }
    }

    private static final class AuthDto {
        public String user;
        public String password;

        private AuthDto() {
        }
    }
}

