/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey.cli;

import io.bdeploy.common.cfg.Configuration;
import io.bdeploy.common.cfg.RemoteValidator;
import io.bdeploy.common.cli.ToolBase;
import io.bdeploy.jersey.cli.LocalLoginData;
import io.bdeploy.jersey.cli.LocalLoginManager;
import io.bdeploy.jersey.cli.LocalLoginServer;
import java.util.Map;

@Configuration.Help(value="Manage local login sessions")
@ToolBase.CliTool.CliName(value="login")
public class LocalLoginTool
extends ToolBase.ConfiguredCliTool<LoginConfig> {
    private static final String LIST_FORMAT = "%1$-20s %2$-30s %3$-15s %4$s";

    public LocalLoginTool() {
        super(LoginConfig.class);
    }

    @Override
    protected void run(LoginConfig config) {
        LocalLoginManager llm = new LocalLoginManager();
        if (config.add() != null) {
            this.addUser(config, llm);
        } else if (config.remove() != null) {
            llm.remove(config.remove());
        } else if (config.use() != null) {
            llm.setCurrent(config.use());
        } else if (config.list()) {
            LocalLoginData data = llm.read();
            this.out().println(String.format(LIST_FORMAT, "Name", "URI", "User", "Current"));
            for (Map.Entry<String, LocalLoginServer> entry : data.servers.entrySet()) {
                this.out().println(String.format(LIST_FORMAT, entry.getKey(), entry.getValue().url, entry.getValue().user, data.current != null && data.current.equals(entry.getKey()) ? "*" : ""));
            }
        } else {
            this.out().println("No action given...");
        }
    }

    private void addUser(LoginConfig config, LocalLoginManager llm) {
        char[] pass;
        String user;
        this.helpAndFailIfMissing(config.remote(), "Missing --remote");
        this.out().println("Please specify user and password for " + config.remote());
        if (config.user() != null) {
            user = config.user();
        } else {
            this.out().print("User: ");
            user = System.console().readLine();
        }
        if (config.password() != null) {
            pass = config.password().toCharArray();
        } else {
            this.out().print("Password: ");
            pass = System.console().readPassword();
        }
        llm.login(config.add(), config.remote(), user, new String(pass));
    }

    @Configuration.Help(value="Configuration for remote access")
    public static @interface LoginConfig {
        @Configuration.Help(value="URI of remote Server")
        @Configuration.EnvironmentFallback(value="BDEPLOY_REMOTE")
        @Configuration.Validator(value=RemoteValidator.class)
        public String remote();

        @Configuration.Help(value="Perform a login to the given remote and store the session locally using the given name")
        public String add();

        @Configuration.Help(value="User to login, read from console if not given")
        public String user();

        @Configuration.Help(value="Password to use when logging in, read from console if not given")
        public String password();

        @Configuration.Help(value="Remove the given stored login session")
        public String remove();

        @Configuration.Help(value="List all stored login sessions", arg=false)
        public boolean list() default false;

        @Configuration.Help(value="The name of the stored login session to switch to")
        public String use();
    }
}

